/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.dgiwg.testsuite.getcapabilities;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.wfs20.core.dgiwg.testsuite.WfsBaseFixture;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Node;

public class GetCapabilitiesSrsTest
extends WfsBaseFixture {
    private static final List<String> EPSG_4326 = GetCapabilitiesSrsTest.initEpsg4326();
    private static final List<String> CRS_84 = GetCapabilitiesSrsTest.initCrs84();

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 9.2., S.30, Requirement 21")
    public void wfsCapabilitiesSrsEpsg4326Supported() {
        this.assertSrs(EPSG_4326);
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 9.2., S.30, Requirement 21")
    public void wfsCapabilitiesSrsCrs84Supported() {
        this.assertSrs(CRS_84);
    }

    private static List<String> initEpsg4326() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("http://www.opengis.net/def/crs/EPSG/0/4326");
        list.add("urn:ogc:def:crs:EPSG::4326");
        return list;
    }

    private static List<String> initCrs84() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
        list.add("urn:ogc:def:crs:OGC:1.3:CRS84");
        return list;
    }

    private void assertSrs(List<String> expectedSrs) {
        String expr = "//wfs:WFS_Capabilities/ows:OperationsMetadata/ows:Parameter[@name='srsName']/ows:AllowedValues/ows:Value = '%s'";
        boolean isOneExpectedSrsSupported = false;
        for (String srs : expectedSrs) {
            if (isOneExpectedSrsSupported) continue;
            String xPathXml = String.format(expr, srs);
            isOneExpectedSrsSupported = ETSAssert.checkXPath((String)xPathXml, (Node)this.wfsMetadata, (NamespaceBindings)NS_BINDINGS);
        }
        Assert.assertTrue((boolean)isOneExpectedSrsSupported, (String)("Capabilities do not contain mandatory SRS in one of the following notation: " + expectedSrs));
    }
}

