/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.utils;

import java.net.URL;
import java.util.logging.Level;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.validation.XmlSchemaCompiler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ValidationUtils {
    public static Schema createWFSSchema(Document wfsMetadata) {
        URL entityCatalog = ValidationUtils.class.getResource("schema-catalog.xml");
        XmlSchemaCompiler xsdCompiler = new XmlSchemaCompiler(entityCatalog);
        Schema wfsSchema = null;
        try {
            URL schemaURL = ValidationUtils.createSchemaUrl(wfsMetadata);
            StreamSource xsdSource = new StreamSource(schemaURL.toString());
            wfsSchema = xsdCompiler.compileXmlSchema(new Source[]{xsdSource});
        }
        catch (SAXException e) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)"Failed to create WFS Schema object.", (Exception)e);
        }
        return wfsSchema;
    }

    private static URL createSchemaUrl(Document wfsMetadata) {
        if ("2.0.0".equals(wfsMetadata.getDocumentElement().getAttribute("version"))) {
            return ValidationUtils.class.getResource("xsd/opengis/wfs/2.0/wfs-2.0.0.xsd");
        }
        return ValidationUtils.class.getResource("xsd/opengis/wfs/2.0/wfs-2.0.2.xsd");
    }
}

