/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.wfs20.testsuite.spatialfilter;

import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.wfs20.core.domain.WfsNamespaces;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.testng.SkipException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSpatialFilterTest
extends QueryFilterFixture {
    protected static final NamespaceBindings NS_BINDINGS = WfsNamespaces.withStandardBindings();
    protected static final List<String> EXPECTED_SPATIAL_OPERATORS = Arrays.asList("Equals", "Disjoint", "Touches", "Within", "Overlaps", "Crosses", "Intersects", "Contains", "DWithin", "Beyond");
    protected XSTypeDefinition gmlGeomBaseType;
    protected Schema wfsSchema;

    protected XSElementDeclaration findGeometryProperty(QName featureType) {
        List geomProps = AppSchemaUtils.getFeaturePropertiesByType((XSModel)this.model, (QName)featureType, (XSTypeDefinition)this.gmlGeomBaseType);
        if (geomProps.isEmpty()) {
            throw new SkipException("Feature type has no geometry properties: " + featureType);
        }
        return (XSElementDeclaration)geomProps.get(0);
    }

    protected void addSpatialOperatorPredicate(Document request, String spatialOperatorName, Element envelope, Element valueRef) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:Filter");
        queryElem.appendChild(filter);
        Element spatialOperator = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:" + spatialOperatorName);
        filter.appendChild(spatialOperator);
        if (null != valueRef) {
            spatialOperator.appendChild(request.importNode(valueRef, true));
        }
        spatialOperator.appendChild(request.importNode(envelope, true));
        if ("DWithin".equals(spatialOperatorName) || "Beyond".equals(spatialOperatorName)) {
            Element distance = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:Distance");
            distance.setAttribute("uom", "m");
            distance.setTextContent("10");
            spatialOperator.appendChild(request.importNode(distance, true));
        }
    }

    protected List<String> parseExpectedSpatialOperators(Document wfsMetadata) throws XPathFactoryConfigurationException, XPathExpressionException {
        ArrayList<String> spatialOperatorNames = new ArrayList<String>();
        String xPathAccessConstraints = "//wfs:WFS_Capabilities/fes:Filter_Capabilities/fes:Spatial_Capabilities/fes:SpatialOperators/fes:SpatialOperator";
        XPath xpath = this.createXPath();
        NodeList spatialOperators = (NodeList)xpath.evaluate(xPathAccessConstraints, wfsMetadata, XPathConstants.NODESET);
        for (int spatialOperatorIndex = 0; spatialOperatorIndex < spatialOperators.getLength(); ++spatialOperatorIndex) {
            Node spatialOperator = spatialOperators.item(spatialOperatorIndex);
            String spatialOperatorName = (String)xpath.evaluate("@name", spatialOperator, XPathConstants.STRING);
            if (spatialOperatorName == null || spatialOperatorName.isEmpty() || !EXPECTED_SPATIAL_OPERATORS.contains(spatialOperatorName)) continue;
            spatialOperatorNames.add(spatialOperatorName);
        }
        return spatialOperatorNames;
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)NS_BINDINGS);
        return xpath;
    }
}

