/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.wfs20.testsuite.temporalfilter;

import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.wfs20.core.domain.WfsNamespaces;
import de.latlon.ets.wfs20.core.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.testng.SkipException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTemporalFilterTest
extends QueryFilterFixture {
    protected static final NamespaceBindings NS_BINDINGS = WfsNamespaces.withStandardBindings();
    protected Schema wfsSchema;

    protected void addTemporalOperatorPredicate(Document request, String temporalOperatorName, Element valueRef, Calendar[] dateRange) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:Filter");
        queryElem.appendChild(filter);
        Element temporalOperator = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:" + temporalOperatorName);
        filter.appendChild(temporalOperator);
        if (null != valueRef) {
            temporalOperator.appendChild(request.importNode(valueRef, true));
        }
        this.appendTimeElement(request, temporalOperatorName, dateRange, temporalOperator);
    }

    protected Iterator<Object[]> createDataProviderWithProtocolsFeatureTypesAndTemporalOperators(List<String> expectedTemporalOperators) throws XPathFactoryConfigurationException, XPathExpressionException {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Set operationBindings = ServiceMetadataUtils.getOperationBindings((Document)this.wfsMetadata, (String)"GetFeature");
        for (ProtocolBinding binding : operationBindings) {
            for (QName featureType : this.featureTypes) {
                for (String temporalOperator : this.parseExpectedTemporalOperators(this.wfsMetadata, expectedTemporalOperators)) {
                    FeatureTypeToPropertyAndValue datePropertyAndValueRange = this.findDatePropertyValue(featureType);
                    if (datePropertyAndValueRange == null) continue;
                    params.add(new Object[]{binding, datePropertyAndValueRange, temporalOperator});
                }
            }
        }
        if (params.isEmpty()) {
            params.add(new Object[]{null, null, null});
        }
        return params.iterator();
    }

    protected List<String> parseExpectedTemporalOperators(Document wfsMetadata, List<String> expectedTemporalOperators) throws XPathFactoryConfigurationException, XPathExpressionException {
        ArrayList<String> temporalOperatorNames = new ArrayList<String>();
        String xPathAccessConstraints = "//wfs:WFS_Capabilities/fes:Filter_Capabilities/fes:Temporal_Capabilities/fes:TemporalOperators/fes:TemporalOperator";
        XPath xpath = this.createXPath();
        NodeList temporalOperators = (NodeList)xpath.evaluate(xPathAccessConstraints, wfsMetadata, XPathConstants.NODESET);
        for (int temporalOperatorIndex = 0; temporalOperatorIndex < temporalOperators.getLength(); ++temporalOperatorIndex) {
            Node temporalOperator = temporalOperators.item(temporalOperatorIndex);
            String temporalOperatorName = (String)xpath.evaluate("@name", temporalOperator, XPathConstants.STRING);
            if (temporalOperatorName == null || temporalOperatorName.isEmpty() || !expectedTemporalOperators.contains(temporalOperatorName)) continue;
            temporalOperatorNames.add(temporalOperatorName);
        }
        return temporalOperatorNames;
    }

    protected void checkIfDataProviderFoundTestableData(ProtocolBinding binding, FeatureTypeToPropertyAndValue featureTypeToPropertyAndValue, String temporalOperatorName) {
        if (binding == null && featureTypeToPropertyAndValue == null && temporalOperatorName == null) {
            throw new SkipException("No feature type with date property found!");
        }
    }

    private FeatureTypeToPropertyAndValue findDatePropertyValue(QName featureType) {
        List<XSElementDeclaration> dateProps = this.findDateProperties(featureType);
        for (XSElementDeclaration prop : dateProps) {
            QName propName = new QName(prop.getNamespace(), prop.getName());
            List valueList = this.dataSampler.getSimplePropertyValues(featureType, propName, null);
            if (valueList.isEmpty()) continue;
            String[] values = new String[valueList.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (String)valueList.get(i);
            }
            Calendar[] valueRange = TimeUtils.calculateDateRange(values);
            if (valueRange.length <= 1) continue;
            TestSuiteLogger.log((Level)Level.FINE, (String)String.format("Found property values of %s, %s", featureType, propName));
            return new FeatureTypeToPropertyAndValue(featureType, prop, valueRange);
        }
        return null;
    }

    private void appendTimeElement(Document request, String temporalOperatorName, Calendar[] dateRange, Element temporalOperator) {
        if (this.isPeriod(temporalOperatorName)) {
            Element timePeriod = request.createElementNS("http://www.opengis.net/gml/3.2", "gml:TimePeriod");
            timePeriod.setAttributeNS("http://www.opengis.net/gml/3.2", "gml:id", "tp_1");
            this.createAndAppendTimePosition(request, "beginPosition", dateRange, timePeriod);
            this.createAndAppendTimePosition(request, "endPosition", null, timePeriod);
            temporalOperator.appendChild(timePeriod);
        } else {
            Element timeInstant = request.createElementNS("http://www.opengis.net/gml/3.2", "gml:TimeInstant");
            timeInstant.setAttributeNS("http://www.opengis.net/gml/3.2", "gml:id", "tp_1");
            this.createAndAppendTimePosition(request, "timePosition", dateRange, timeInstant);
            temporalOperator.appendChild(timeInstant);
        }
    }

    private void createAndAppendTimePosition(Document request, String gmlName, Calendar[] dateRange, Element parent) {
        Element position = request.createElementNS("http://www.opengis.net/gml/3.2", "gml:" + gmlName);
        if (dateRange == null) {
            position.setAttribute("indeterminatePosition", "unknown");
        } else {
            position.setTextContent(TimeUtils.calculateValueBetween(dateRange));
        }
        parent.appendChild(position);
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)NS_BINDINGS);
        return xpath;
    }

    private List<XSElementDeclaration> findDateProperties(QName featureType) {
        ArrayList<XSElementDeclaration> dateProperties = new ArrayList<XSElementDeclaration>();
        for (XSTypeDefinition dataType : this.getTemporalDataTypes(this.model)) {
            List props = AppSchemaUtils.getFeaturePropertiesByType((XSModel)this.model, (QName)featureType, (XSTypeDefinition)dataType);
            if (props.isEmpty()) continue;
            dateProperties.addAll(props);
        }
        if (!dateProperties.isEmpty()) {
            Collections.sort(dateProperties, Collections.reverseOrder());
            return dateProperties;
        }
        return Collections.emptyList();
    }

    private Set<XSTypeDefinition> getTemporalDataTypes(XSModel model) {
        HashSet<XSTypeDefinition> dataTypes = new HashSet<XSTypeDefinition>();
        dataTypes.add(model.getTypeDefinition("dateTime", "http://www.w3.org/2001/XMLSchema"));
        dataTypes.add(model.getTypeDefinition("date", "http://www.w3.org/2001/XMLSchema"));
        dataTypes.add(model.getTypeDefinition("gYearMonth", "http://www.w3.org/2001/XMLSchema"));
        dataTypes.add(model.getTypeDefinition("gYear", "http://www.w3.org/2001/XMLSchema"));
        return dataTypes;
    }

    private boolean isPeriod(String temporalOperatorName) {
        return Arrays.asList("During").contains(temporalOperatorName);
    }

    class FeatureTypeToPropertyAndValue {
        private final QName featureType;
        private final XSElementDeclaration property;
        private final Calendar[] valueRange;

        public FeatureTypeToPropertyAndValue(QName featureType, XSElementDeclaration property, Calendar[] valueRange) {
            this.featureType = featureType;
            this.property = property;
            this.valueRange = valueRange;
        }

        public QName getFeatureType() {
            return this.featureType;
        }

        public XSElementDeclaration getProperty() {
            return this.property;
        }

        public Calendar[] getValueRange() {
            return this.valueRange;
        }

        public String toString() {
            return "FeatureTypeToPropertyAndValue [featureType=" + this.featureType + ", property=" + this.property + "]";
        }
    }
}

