/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.ConcatenatedGridResource;
import org.apache.sis.storage.aggregate.DimensionSelector;
import org.apache.sis.storage.aggregate.GridSlice;
import org.apache.sis.storage.aggregate.GridSliceLocator;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.storage.aggregate.GroupAggregate;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

final class GroupByTransform
extends Group<GridSlice> {
    private final GridGeometry geometry;
    private final MathTransform gridToCRS;
    MergeStrategy strategy;

    GroupByTransform(GridGeometry geometry, MathTransform gridToCRS, MergeStrategy strategy) {
        this.geometry = geometry;
        this.gridToCRS = gridToCRS;
        this.strategy = strategy;
    }

    @Override
    final String createName(Locale locale) {
        Vocabulary v = Vocabulary.getResources(locale);
        StringBuffer b = new StringBuffer(v.getLabel((short)172));
        NumberFormat f = NumberFormat.getIntegerInstance(v.getLocale());
        FieldPosition p = new FieldPosition(0);
        String separator = "";
        for (double r : this.geometry.getResolution(true)) {
            f.setMaximumFractionDigits(Math.max(DecimalFunctions.fractionDigitsForDelta(r / 100.0, false), 0));
            f.format(r, b.append(separator), p);
            separator = " \u00d7 ";
        }
        return b.toString();
    }

    final Matrix linearTransform(MathTransform crsToGrid) {
        if (this.gridToCRS.getTargetDimensions() == crsToGrid.getSourceDimensions()) {
            return MathTransforms.getMatrix((MathTransform)MathTransforms.concatenate((MathTransform)this.gridToCRS, (MathTransform)crsToGrid));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] findConcatenatedDimensions() {
        Object[] selects;
        List list = this.members;
        synchronized (list) {
            int i = this.members.size();
            selects = new DimensionSelector[this.geometry.getDimension()];
            int dim = selects.length;
            while (--dim >= 0) {
                selects[dim] = new DimensionSelector(dim, i);
            }
            while (--i >= 0) {
                ((GridSlice)this.members.get(i)).getGridExtent(i, (DimensionSelector[])selects);
            }
        }
        ((Stream)Arrays.stream(selects).parallel()).forEach(DimensionSelector::finish);
        Arrays.sort(selects);
        int[] dimensions = new int[selects.length];
        int count = 0;
        int i = selects.length;
        while (--i >= 0 && !((DimensionSelector)selects[i]).isConstantPosition) {
            dimensions[count++] = ((DimensionSelector)selects[i]).dimension;
        }
        return ArraysExt.resize(dimensions, count);
    }

    final Resource createResource(StoreListeners parentListeners, List<SampleDimension> ranges) {
        int n = this.members.size();
        if (n == 1) {
            return ((GridSlice)this.members.get((int)0)).resource;
        }
        GridCoverageResource[] slices = new GridCoverageResource[n];
        String name = this.getName(parentListeners);
        int[] dimensions = this.findConcatenatedDimensions();
        if (dimensions.length == 0) {
            for (int i = 0; i < n; ++i) {
                slices[i] = ((GridSlice)this.members.get((int)i)).resource;
            }
            return new GroupAggregate(parentListeners, name, slices, ranges);
        }
        GridSliceLocator locator = new GridSliceLocator(this.members, dimensions[0], slices);
        GridGeometry domain = locator.union(this.geometry, this.members, GridSlice::getGridExtent);
        return new ConcatenatedGridResource(name, parentListeners, domain, ranges, slices, locator, this.strategy);
    }
}

