/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetPropertyValueTests
extends BaseFixture {
    private Schema wfsSchema;

    @BeforeClass
    public void setupClassFixture(ITestContext testContext) {
        this.wfsSchema = (Schema)testContext.getSuite().getAttribute(SuiteAttribute.WFS_SCHEMA.getName());
        Assert.assertNotNull((Object)this.wfsSchema, (String)"WFS schema not found in suite fixture.");
    }

    @BeforeMethod
    public void buildRequestEntity() {
        this.reqEntity = WFSMessage.createRequestEntity("GetPropertyValue", this.wfsVersion);
    }

    @Test(description="See ISO 19142: 10.2.4.3", dataProvider="protocol-binding")
    public void getProperty_gmlId(ProtocolBinding binding) {
        this.setValueReference(this.reqEntity, "@gml:id");
        this.addQuery(this.reqEntity, (QName)this.featureTypes.get(0));
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetPropertyValue", binding);
        Response rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        Document entity = this.extractBodyAsDocument(rsp);
        ETSAssert.assertQualifiedName(entity.getDocumentElement(), new QName("http://www.opengis.net/wfs/2.0", "ValueCollection"));
        NodeList members = entity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "member");
        for (int i = 0; i < members.getLength(); ++i) {
            String value = members.item(i).getTextContent();
            Assert.assertFalse((boolean)value.isEmpty(), (String)("Found empty wfs:member[" + i + "]"));
        }
    }

    @Test(description="See ISO 19142: 7.5, 10.4", dataProvider="protocol-binding")
    public void getProperty_emptyValueRef(ProtocolBinding binding) {
        this.setValueReference(this.reqEntity, "");
        this.addQuery(this.reqEntity, (QName)this.featureTypes.get(0));
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetPropertyValue", binding);
        Response rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        Document entity = this.extractBodyAsDocument(rsp);
        ETSAssert.assertXPath("//ows:Exception/@exceptionCode = 'InvalidParameterValue'", entity.getDocumentElement(), null);
    }

    void setValueReference(Document entity, String xpath) {
        entity.getDocumentElement().setAttribute("valueReference", xpath);
    }

    void addQuery(Document request, QName qName) {
        Element docElem = request.getDocumentElement();
        Object nsPrefix = docElem.lookupPrefix(qName.getNamespaceURI());
        if (null == nsPrefix) {
            nsPrefix = "ns" + Integer.toString((int)(Math.random() * 100.0));
        }
        Element query = request.createElementNS("http://www.opengis.net/wfs/2.0", "Query");
        query.setPrefix("wfs");
        query.setAttribute("typeNames", (String)nsPrefix + ":" + qName.getLocalPart());
        docElem.appendChild(query);
        docElem.setAttribute("xmlns:" + (String)nsPrefix, qName.getNamespaceURI());
    }
}

