/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.joins;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSElementDeclaration;
import org.opengis.cite.iso19142.util.FeatureProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JoinQueryUtils {
    public static void appendSpatialJoinQuery(Document req, String operator, List<FeatureProperty> properties) {
        if (!req.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + req.getDocumentElement().getNodeName());
        }
        if (null == properties) {
            throw new NullPointerException("Feature properties are required.");
        }
        if (properties.size() != 2) {
            throw new IllegalArgumentException("Two feature properties are required, but received " + properties.size());
        }
        Element docElem = req.getDocumentElement();
        Element qryElem = req.createElementNS("http://www.opengis.net/wfs/2.0", "wfs:Query");
        docElem.appendChild(qryElem);
        StringBuilder typeNames = new StringBuilder();
        for (FeatureProperty property : properties) {
            QName featureType = property.getFeatureType();
            Object nsPrefix = qryElem.lookupPrefix(featureType.getNamespaceURI());
            if (null == nsPrefix) {
                nsPrefix = "ns" + Integer.toString((int)(Math.random() * 100.0));
                qryElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)nsPrefix, featureType.getNamespaceURI());
            }
            typeNames.append((String)nsPrefix).append(':').append(featureType.getLocalPart()).append(' ');
        }
        qryElem.setAttribute("typeNames", typeNames.toString().trim());
        Element filter = req.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
        qryElem.appendChild(filter);
        Element predicateElem = req.createElementNS("http://www.opengis.net/fes/2.0", operator);
        filter.appendChild(predicateElem);
        JoinQueryUtils.appendValueRefToPredicate(predicateElem, properties.get(0));
        JoinQueryUtils.appendValueRefToPredicate(predicateElem, properties.get(1));
    }

    public static void appendValueRefToPredicate(Element predicateElem, FeatureProperty featureProperty) {
        Element valueRef = predicateElem.getOwnerDocument().createElementNS("http://www.opengis.net/fes/2.0", "ValueReference");
        predicateElem.appendChild(valueRef);
        XSElementDeclaration propDecl = featureProperty.getDeclaration();
        String nsURI = propDecl.getNamespace();
        Object propPrefix = predicateElem.lookupPrefix(nsURI);
        if (null == propPrefix) {
            propPrefix = "ns-" + Integer.toString((int)(Math.random() * 100.0));
            valueRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)propPrefix, nsURI);
        }
        QName featureType = featureProperty.getFeatureType();
        String typePrefix = predicateElem.lookupPrefix(featureType.getNamespaceURI());
        StringBuilder xpath = new StringBuilder();
        xpath.append(typePrefix).append(':').append(featureType.getLocalPart());
        xpath.append('/').append((String)propPrefix).append(':');
        xpath.append(propDecl.getName());
        valueRef.setTextContent(xpath.toString());
    }
}

