/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

@Consumes(value={"application/soap+xml"})
public class SOAPMessageConsumer
implements MessageBodyReader<SOAPMessage> {
    private static final Logger LOGR = Logger.getLogger(SOAPMessageConsumer.class.getPackage().getName());

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(SOAPMessage.class);
    }

    public SOAPMessage readFrom(Class<SOAPMessage> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        SOAPMessage message = null;
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            message = messageFactory.createMessage();
            SOAPPart soapPart = message.getSOAPPart();
            StreamSource messageSource = new StreamSource(entityStream);
            soapPart.setContent((Source)messageSource);
        }
        catch (SOAPException se) {
            LOGR.warning("Unable to create SOAPMessage.\n" + se.getMessage());
        }
        return message;
    }
}

