/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.temporal.Period;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TimeUtils {
    private static final DocumentBuilder DOC_BUILDER = TimeUtils.initDocBuilder();

    private static DocumentBuilder initDocBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            TestSuiteLogger.log(Level.WARNING, "TimeUtils: Failed to create DocumentBuilder", e);
        }
        return builder;
    }

    public static Document intervalAsGML(ZonedDateTime startDateTime, ZonedDateTime endDateTime) {
        Document gmlTimePeriod;
        try {
            gmlTimePeriod = DOC_BUILDER.parse(TimeUtils.class.getResourceAsStream("TimePeriod.xml"));
        }
        catch (IOException | SAXException e) {
            return null;
        }
        String beginPosition = startDateTime.format(DateTimeFormatter.ISO_INSTANT);
        gmlTimePeriod.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "beginPosition").item(0).setTextContent(beginPosition);
        String endPosition = endDateTime.format(DateTimeFormatter.ISO_INSTANT);
        gmlTimePeriod.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "endPosition").item(0).setTextContent(endPosition);
        return gmlTimePeriod;
    }

    public static Document periodAsGML(Period period) {
        return TimeUtils.periodAsGML(period, null);
    }

    public static Document periodAsGML(Period period, ZoneOffset offset) {
        if (null == offset) {
            offset = ZoneOffset.UTC;
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        String startOfPeriod = period.getBeginning().getDate().toInstant().atOffset(offset).toString();
        ZonedDateTime startDateTime = ZonedDateTime.parse(startOfPeriod, dateTimeFormatter);
        String endOfPeriod = period.getEnding().getDate().toInstant().atOffset(offset).toString();
        ZonedDateTime endDateTime = ZonedDateTime.parse(endOfPeriod, dateTimeFormatter);
        return TimeUtils.intervalAsGML(startDateTime, endDateTime);
    }

    public static Document periodAsGMLSubtractOneDay(Period period) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXX");
        String startOfPeriod = period.getBeginning().getDate().toInstant().toString();
        ZonedDateTime startDateTime = ZonedDateTime.parse(startOfPeriod, dateTimeFormatter);
        startDateTime = startDateTime.minus(1L, ChronoUnit.DAYS);
        String endOfPeriod = period.getEnding().getDate().toInstant().toString();
        ZonedDateTime endDateTime = ZonedDateTime.parse(endOfPeriod, dateTimeFormatter);
        endDateTime = endDateTime.minus(1L, ChronoUnit.DAYS);
        return TimeUtils.intervalAsGML(startDateTime, endDateTime);
    }

    public static Document periodAsGMLAddOneDay(Period period) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXX");
        String startOfPeriod = period.getBeginning().getDate().toInstant().toString();
        ZonedDateTime startDateTime = ZonedDateTime.parse(startOfPeriod, dateTimeFormatter);
        startDateTime = startDateTime.plus(1L, ChronoUnit.DAYS);
        String endOfPeriod = period.getEnding().getDate().toInstant().toString();
        ZonedDateTime endDateTime = ZonedDateTime.parse(endOfPeriod, dateTimeFormatter);
        endDateTime = endDateTime.plus(1L, ChronoUnit.DAYS);
        return TimeUtils.intervalAsGML(startDateTime, endDateTime);
    }

    public static Document instantAsGML(org.opengis.temporal.Instant instant, ZoneOffset offset) {
        Document gmlTimeInstant;
        if (null == offset) {
            offset = ZoneOffset.UTC;
        }
        try {
            gmlTimeInstant = DOC_BUILDER.parse(TimeUtils.class.getResourceAsStream("TimeInstant.xml"));
        }
        catch (IOException | SAXException e) {
            return null;
        }
        OffsetDateTime tPos = instant.getDate().toInstant().atOffset(offset);
        String timePositionValue = tPos.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        Node timePosition = gmlTimeInstant.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "timePosition").item(0);
        timePosition.setTextContent(timePositionValue);
        return gmlTimeInstant;
    }

    public static Document instantAsGMLSubtractOneDay(org.opengis.temporal.Instant instant, ZoneOffset offset) {
        Document gmlTimeInstant;
        if (null == offset) {
            offset = ZoneOffset.UTC;
        }
        try {
            gmlTimeInstant = DOC_BUILDER.parse(TimeUtils.class.getResourceAsStream("TimeInstant.xml"));
        }
        catch (IOException | SAXException e) {
            return null;
        }
        OffsetDateTime tPos = TimeUtils.ogcInstantToJavaInstantSubtractOneDay(instant).atOffset(offset);
        String timePositionValue = tPos.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        Node timePosition = gmlTimeInstant.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "timePosition").item(0);
        timePosition.setTextContent(timePositionValue);
        return gmlTimeInstant;
    }

    private static Instant ogcInstantToJavaInstantSubtractOneDay(org.opengis.temporal.Instant instant) {
        return instant.getDate().toInstant().minus(1L, ChronoUnit.DAYS);
    }
}

