/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.util.CharSequences;

public final class StandardDateFormat
extends DateFormat {
    public static final String UTC = "UTC";
    private static final OffsetTime MIDNIGHT = OffsetTime.of(0, 0, 0, 0, ZoneOffset.UTC);
    public static final DateTimeFormatter FORMAT = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 5, SignStyle.NORMAL).optionalStart().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().optionalEnd().optionalEnd().optionalStart().appendZoneOrOffsetId().toFormatter(Locale.ROOT);
    private static TemporalQuery<?>[] QUERIES = new TemporalQuery[]{Instant::from, LocalDateTime::from, LocalDate::from};
    public static final int MILLISECONDS_PER_DAY = 86400000;
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int NANOS_PER_MILLISECOND = 1000000;
    public static final int NANOS_PER_SECOND = 1000000000;
    private DateTimeFormatter format;

    public static Temporal parseBest(CharSequence text) {
        return text != null ? (Temporal)FORMAT.parseBest(StandardDateFormat.toISO(text, 0, text.length()), QUERIES) : null;
    }

    public static Instant parseInstantUTC(CharSequence text) {
        return text != null ? StandardDateFormat.parseInstantUTC(text, 0, text.length()) : null;
    }

    public static Instant parseInstantUTC(CharSequence text, int lower, int upper) {
        TemporalAccessor date = FORMAT.parseBest(StandardDateFormat.toISO(text, lower, upper), QUERIES);
        if (date instanceof Instant) {
            return (Instant)date;
        }
        OffsetDateTime time = date instanceof LocalDateTime ? ((LocalDateTime)date).atOffset(ZoneOffset.UTC) : ((LocalDate)date).atTime(MIDNIGHT);
        return time.toInstant();
    }

    static CharSequence toISO(CharSequence text, int lower, int upper) {
        int n;
        lower = CharSequences.skipLeadingWhitespaces(text, lower, upper);
        upper = CharSequences.skipTrailingWhitespaces(text, lower, upper);
        StringBuilder buffer = null;
        int cp = 0;
        for (int i = upper; i > lower; i -= n) {
            int c;
            block7: {
                boolean isDateTimeSeparator;
                int end;
                block8: {
                    c = Character.codePointBefore(text, i);
                    n = Character.charCount(c);
                    if (!Character.isWhitespace(c)) break block7;
                    end = i;
                    i = CharSequences.skipTrailingWhitespaces(text, lower, i - n);
                    c = Character.codePointBefore(text, i);
                    n = Character.charCount(c);
                    isDateTimeSeparator = false;
                    if (!Character.isDigit(cp) || !Character.isDigit(c)) break block8;
                    boolean bl = isDateTimeSeparator = CharSequences.indexOf(text, 58, lower, upper) > end;
                    if (!isDateTimeSeparator) break block7;
                }
                if (buffer == null) {
                    buffer = new StringBuilder(upper - lower).append(text, lower, upper);
                    text = buffer;
                    i -= lower;
                    end -= lower;
                    lower = 0;
                }
                if (isDateTimeSeparator) {
                    buffer.replace(i, end, "T");
                } else {
                    buffer.delete(i, end);
                }
                upper = buffer.length();
            }
            cp = c;
        }
        return text.subSequence(lower, upper);
    }

    public static Temporal toHeuristicTemporal(Date date, ZoneId zone) {
        if (date == null) {
            return null;
        }
        long time = date.getTime();
        if (time % 86400000L == 0L) {
            return LocalDate.ofEpochDay(time / 86400000L);
        }
        Instant instant = Instant.ofEpochMilli(time);
        if (zone == null) {
            zone = ZoneOffset.UTC;
        } else if (!zone.equals(ZoneOffset.UTC)) {
            return OffsetDateTime.ofInstant(instant, zone);
        }
        return LocalDateTime.ofInstant(instant, zone);
    }

    public static Date toDate(TemporalAccessor temporal) {
        long millis;
        if (temporal == null) {
            return null;
        }
        if (temporal instanceof Instant) {
            millis = ((Instant)temporal).toEpochMilli();
        } else if (temporal.isSupported(ChronoField.INSTANT_SECONDS)) {
            millis = Math.multiplyExact(temporal.getLong(ChronoField.INSTANT_SECONDS), 1000);
            millis = Math.addExact(millis, temporal.getLong(ChronoField.NANO_OF_SECOND) / 1000000L);
        } else {
            millis = Math.multiplyExact(temporal.getLong(ChronoField.EPOCH_DAY), 86400000);
            if (temporal.isSupported(ChronoField.MILLI_OF_DAY)) {
                millis = Math.addExact(millis, temporal.getLong(ChronoField.MILLI_OF_DAY));
            }
        }
        return new Date(millis);
    }

    public static boolean hasDateFields(Class<?> date) {
        return date == LocalDate.class || date == LocalDateTime.class || date == OffsetDateTime.class || date == ZonedDateTime.class;
    }

    public static boolean hasTimeFields(Class<?> date) {
        return date == LocalTime.class || date == OffsetTime.class || date == LocalDateTime.class || date == OffsetDateTime.class || date == ZonedDateTime.class;
    }

    public StandardDateFormat() {
        this.format = FORMAT;
    }

    public StandardDateFormat(Locale locale) {
        this.format = FORMAT.withLocale(locale);
    }

    public StandardDateFormat(Locale locale, TimeZone zone) {
        this(locale);
        if (!UTC.equals(zone.getID())) {
            this.setTimeZone(zone);
        }
    }

    @Override
    public final Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance(this.getTimeZone(), this.format.getLocale());
        }
        return this.calendar;
    }

    @Override
    public final NumberFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getInstance(this.format.getLocale());
        }
        return this.numberFormat;
    }

    @Override
    public final TimeZone getTimeZone() {
        ZoneId zone = this.format.getZone();
        return TimeZone.getTimeZone(zone != null ? zone : ZoneOffset.UTC);
    }

    @Override
    public final void setTimeZone(TimeZone zone) {
        this.format = this.format.withZone(zone.toZoneId());
        if (this.calendar != null) {
            super.setTimeZone(zone);
        }
    }

    @Override
    public final void setLenient(boolean lenient) {
        this.getCalendar().setLenient(lenient);
    }

    @Override
    public final boolean isLenient() {
        return this.getCalendar().isLenient();
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        this.format.formatTo(StandardDateFormat.toHeuristicTemporal(date, null), toAppendTo);
        return toAppendTo;
    }

    @Override
    public Date parse(String text, ParsePosition position) {
        try {
            return StandardDateFormat.toDate(this.format.parse((CharSequence)text, position));
        }
        catch (ArithmeticException | DateTimeException e) {
            position.setErrorIndex(StandardDateFormat.getErrorIndex(e, position));
            return null;
        }
    }

    @Override
    public Date parse(String text) throws ParseException {
        try {
            return StandardDateFormat.toDate(this.format.parse(StandardDateFormat.toISO(text, 0, text.length())));
        }
        catch (ArithmeticException | DateTimeException e) {
            throw (ParseException)new ParseException(e.getLocalizedMessage(), StandardDateFormat.getErrorIndex(e, null)).initCause(e);
        }
    }

    private static int getErrorIndex(RuntimeException e, ParsePosition position) {
        if (e instanceof DateTimeParseException) {
            return ((DateTimeParseException)e).getErrorIndex();
        }
        if (position != null) {
            return position.getIndex();
        }
        return 0;
    }

    @Override
    public int hashCode() {
        return 31 * this.format.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof StandardDateFormat && this.format.equals(((StandardDateFormat)obj).format);
    }

    @Override
    public Object clone() {
        StandardDateFormat clone = new StandardDateFormat();
        clone.format = this.format;
        return clone;
    }
}

