/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DirectPositionType", propOrder={"value"})
public class DirectPositionType
implements DirectPosition {
    public static final Map<String, CoordinateReferenceSystem> cachedCRS = new HashMap<String, CoordinateReferenceSystem>();
    @XmlValue
    protected List<Double> value;
    @XmlAttribute
    @XmlSchemaType(name="positiveInteger")
    protected Integer srsDimension;
    @XmlAttribute
    @XmlSchemaType(name="anyURI")
    protected String srsName;
    @XmlAttribute
    protected List<String> axisLabels;
    @XmlAttribute
    protected List<String> uomLabels;

    DirectPositionType() {
    }

    public DirectPositionType(String srsName, int srsDimension, List<String> axisLabels, List<Double> value, List<String> uomLabels) {
        this.srsName = srsName;
        this.srsDimension = srsDimension;
        this.axisLabels = axisLabels;
        this.value = value;
        this.uomLabels = uomLabels;
    }

    public DirectPositionType(String srsName, int srsDimension, List<String> axisLabels, List<Double> value) {
        this.srsName = srsName;
        this.srsDimension = srsDimension;
        this.axisLabels = axisLabels;
        this.value = value;
    }

    public DirectPositionType(String srsName, int srsDimension, List<Double> value) {
        this.srsName = srsName;
        this.srsDimension = srsDimension;
        this.value = value;
    }

    public DirectPositionType(List<Double> value) {
        this.value = value;
        this.srsDimension = null;
    }

    public DirectPositionType(Double ... values) {
        this.value = new ArrayList<Double>();
        for (Double pt : values) {
            this.value.add(pt);
        }
        this.srsDimension = null;
    }

    public DirectPositionType(Position position) {
        if (position != null) {
            this.value = new ArrayList<Double>();
            for (double d : position.getDirectPosition().getCoordinate()) {
                this.value.add(d);
            }
        }
    }

    public List<Double> getValue() {
        if (this.value == null) {
            this.value = new ArrayList<Double>();
        }
        return this.value;
    }

    public String getSrsName() {
        return this.srsName;
    }

    public void setSrsName(String value) {
        this.srsName = value;
    }

    public Integer getSrsDimension() {
        return this.srsDimension;
    }

    public void setSrsDimension(Integer value) {
        this.srsDimension = value;
    }

    public List<String> getAxisLabels() {
        if (this.axisLabels == null) {
            this.axisLabels = new ArrayList<String>();
        }
        return this.axisLabels;
    }

    public List<String> getUomLabels() {
        if (this.uomLabels == null) {
            this.uomLabels = new ArrayList<String>();
        }
        return this.uomLabels;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        CoordinateReferenceSystem crs = null;
        if (this.srsName != null) {
            try {
                if (cachedCRS.containsKey(this.srsName)) {
                    return cachedCRS.get(this.srsName);
                }
                crs = CRS.forCode((String)this.srsName);
            }
            catch (NoSuchAuthorityCodeException ex) {
                Logger.getLogger("org.geotoolkit.referencing").log(Level.WARNING, ex.getMessage());
            }
            catch (FactoryException ex) {
                Logger.getLogger("org.geotoolkit.referencing").log(Level.WARNING, null, ex);
            }
            cachedCRS.put(this.srsName, crs);
        }
        return crs;
    }

    public int getDimension() {
        return this.getSrsDimension();
    }

    public double[] getCoordinate() {
        double[] coords = new double[this.value.size()];
        int n = this.value.size();
        for (int i = 0; i < n; ++i) {
            coords[i] = this.value.get(i);
        }
        return coords;
    }

    public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        return this.value.get(dimension);
    }

    public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException, UnsupportedOperationException {
        this.value.remove(dimension);
        this.value.add(dimension, value);
    }

    public DirectPosition getDirectPosition() {
        return this;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("[DirectPositionType]:");
        if (this.srsName != null) {
            s.append("srsName = ").append(this.srsName).append('\n');
        }
        if (this.srsDimension != null) {
            s.append(" srsDimension = ").append(this.srsDimension).append('\n');
        }
        if (this.value != null) {
            s.append(" value: ").append('\n');
            for (double v : this.value) {
                s.append(v).append(", ");
            }
        }
        return s.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DirectPositionType) {
            DirectPositionType that = (DirectPositionType)object;
            return Objects.equals(this.axisLabels, that.axisLabels) && Objects.equals(this.srsDimension, that.srsDimension) && Objects.equals(this.srsName, that.srsName) && Objects.equals(this.uomLabels, that.uomLabels) && Objects.equals(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 71 * hash + this.srsDimension;
        hash = 71 * hash + (this.srsName != null ? this.srsName.hashCode() : 0);
        hash = 71 * hash + (this.axisLabels != null ? this.axisLabels.hashCode() : 0);
        hash = 71 * hash + (this.uomLabels != null ? this.uomLabels.hashCode() : 0);
        return hash;
    }
}

