/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.referencing.CRS;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSLineString;
import org.geotoolkit.internal.jaxb.CoordinateReferenceSystemAdapter;
import org.geotoolkit.internal.jaxb.CoordinatesType;
import org.geotoolkit.internal.jaxb.PosListType;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="lineStringPosListType", namespace="http://www.opengis.net/gml")
public class LineStringPosListType {
    @XmlAttribute
    private String srsName;
    @XmlElement(namespace="http://www.opengis.net/gml")
    private PosListType posList;
    @XmlElement(namespace="http://www.opengis.net/gml")
    private CoordinatesType coordinates;

    public LineStringPosListType() {
    }

    public LineStringPosListType(List<Double> value) {
        this.posList = new PosListType(value);
    }

    public LineStringPosListType(JTSLineString lineString) {
        this.srsName = CoordinateReferenceSystemAdapter.getSrsName(lineString.getCoordinateReferenceSystem());
        ArrayList<Double> value = new ArrayList<Double>();
        for (Position p : lineString.getPositions()) {
            for (int i = 0; i < p.getDirectPosition().getDimension(); ++i) {
                value.add(p.getDirectPosition().getOrdinate(i));
            }
        }
        this.posList = new PosListType(value);
    }

    public JTSLineString getJTSLineString() {
        JTSLineString result;
        block6: {
            block5: {
                CoordinateReferenceSystem crs = null;
                if (this.srsName != null) {
                    try {
                        crs = CRS.forCode((String)this.srsName);
                    }
                    catch (FactoryException ex) {
                        Logger.getLogger("org.geotoolkit.internal.jaxb").log(Level.WARNING, null, ex);
                    }
                }
                result = new JTSLineString(crs);
                if (this.posList == null) break block5;
                for (int i = 0; i < this.posList.getValue().size(); i += 2) {
                    result.getPositions().add((Position)new GeneralDirectPosition(new double[]{this.posList.getValue().get(i), this.posList.getValue().get(i + 1)}));
                }
                break block6;
            }
            if (this.coordinates == null) break block6;
            for (int i = 0; i < this.coordinates.getValues().size(); i += 2) {
                result.getPositions().add((Position)new GeneralDirectPosition(new double[]{this.coordinates.getValues().get(i), this.coordinates.getValues().get(i + 1)}));
            }
        }
        return result;
    }

    public String getSrsName() {
        return this.srsName;
    }

    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    public PosListType getPosList() {
        return this.posList;
    }

    public void setPosList(PosListType posList) {
        this.posList = posList;
    }

    public CoordinatesType getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(CoordinatesType coordinates) {
        this.coordinates = coordinates;
    }
}

