/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.display.shape;

import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class ProjectedPathIterator
extends Point2D.Double
implements PathIterator {
    private static final double TOLERANCE = 1.0E-5;
    private final PathIterator iterator;
    private final MathTransform2D projection;
    private final double[] buffer;
    private transient double \u03bb;
    private transient double \u03c6;
    private transient double \u03bb0;
    private transient double \u03c60;
    private transient double x0;
    private transient double y0;
    private transient Matrix derivative;
    private transient double ctrlx1;
    private transient double ctrly1;
    private transient double ctrlx2;
    private transient double ctrly2;
    private transient boolean isClosing;

    ProjectedPathIterator(PathIterator iterator, MathTransform2D projection) {
        this.iterator = iterator;
        this.projection = projection;
        this.buffer = new double[2];
    }

    @Override
    public int getWindingRule() {
        return this.iterator.getWindingRule();
    }

    @Override
    public boolean isDone() {
        return !this.isClosing && this.iterator.isDone();
    }

    @Override
    public void next() {
        if (!this.isClosing) {
            this.iterator.next();
        }
    }

    private void transform(double[] coords, int n) throws TransformException {
        int i0 = n - 1 << 1;
        int i1 = i0 + 1;
        this.\u03bb = coords[i0];
        this.\u03c6 = coords[i1];
        this.projection.transform(coords, 0, coords, 0, n);
        this.x = coords[i0];
        this.y = coords[i1];
        this.derivative = null;
    }

    private void transform(float[] coords, int n) throws TransformException {
        if (--n != 0) {
            this.projection.transform(coords, 0, coords, 0, n);
        }
        int i0 = n << 1;
        int i1 = i0 + 1;
        this.x = this.\u03bb = (double)coords[i0];
        this.y = this.\u03c6 = (double)coords[i1];
        Point2D p = this.projection.transform((Point2D)this, (Point2D)this);
        if (p != this) {
            this.setLocation(p);
        }
        coords[i0] = (float)this.x;
        coords[i1] = (float)this.y;
        this.derivative = null;
    }

    @Override
    public int currentSegment(double[] coords) {
        if (this.isClosing) {
            this.isClosing = false;
            return 4;
        }
        int type = this.iterator.currentSegment(coords);
        try {
            switch (type) {
                case 0: {
                    this.\u03bb0 = coords[0];
                    this.\u03c60 = coords[1];
                    this.transform(coords, 1);
                    this.x0 = coords[0];
                    this.y0 = coords[1];
                    break;
                }
                case 2: {
                    this.transform(coords, 2);
                    break;
                }
                case 3: {
                    this.transform(coords, 3);
                    break;
                }
                case 4: {
                    if (this.x0 == this.x && this.y0 == this.y) break;
                    this.isClosing = true;
                    coords[0] = this.\u03bb0;
                    coords[1] = this.\u03c60;
                }
                case 1: {
                    double x1 = this.x;
                    double y1 = this.y;
                    double \u0394\u03bb = coords[0] - this.\u03bb;
                    double \u0394\u03c6 = coords[1] - this.\u03c6;
                    Matrix D1 = this.derivative;
                    if (D1 == null) {
                        this.x = this.\u03bb;
                        this.y = this.\u03c6;
                        D1 = this.projection.derivative((Point2D)this);
                    }
                    this.\u03bb = coords[0];
                    this.\u03c6 = coords[1];
                    this.derivativeAndTransform(coords);
                    type = this.transformSegment(\u0394\u03bb, \u0394\u03c6, x1, y1, D1);
                    int i = 0;
                    switch (type) {
                        case 3: {
                            coords[i++] = this.ctrlx1;
                            coords[i++] = this.ctrly1;
                        }
                        case 2: {
                            coords[i++] = this.ctrlx2;
                            coords[i++] = this.ctrly2;
                        }
                        case 1: {
                            coords[i++] = this.x;
                            coords[i++] = this.y;
                        }
                    }
                    break;
                }
            }
        }
        catch (TransformException cause) {
            IllegalPathStateException ex = new IllegalPathStateException(cause.getLocalizedMessage());
            ex.initCause(cause);
            throw ex;
        }
        return type;
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.isClosing) {
            this.isClosing = false;
            return 4;
        }
        int type = this.iterator.currentSegment(coords);
        try {
            switch (type) {
                case 0: {
                    this.\u03bb0 = coords[0];
                    this.\u03c60 = coords[1];
                    this.transform(coords, 1);
                    this.x0 = coords[0];
                    this.y0 = coords[1];
                    break;
                }
                case 2: {
                    this.transform(coords, 2);
                    break;
                }
                case 3: {
                    this.transform(coords, 3);
                    break;
                }
                case 4: {
                    if (this.x0 == this.x && this.y0 == this.y) break;
                    this.isClosing = true;
                    coords[0] = (float)this.\u03bb0;
                    coords[1] = (float)this.\u03c60;
                }
                case 1: {
                    double x1 = this.x;
                    double y1 = this.y;
                    double \u0394\u03bb = (double)coords[0] - this.\u03bb;
                    double \u0394\u03c6 = (double)coords[1] - this.\u03c6;
                    Matrix D1 = this.derivative;
                    if (D1 == null) {
                        this.x = this.\u03bb;
                        this.y = this.\u03c6;
                        D1 = this.projection.derivative((Point2D)this);
                    }
                    this.buffer[0] = this.\u03bb = (double)coords[0];
                    this.buffer[1] = this.\u03c6 = (double)coords[1];
                    this.derivativeAndTransform(this.buffer);
                    type = this.transformSegment(\u0394\u03bb, \u0394\u03c6, x1, y1, D1);
                    int i = 0;
                    switch (type) {
                        case 3: {
                            coords[i++] = (float)this.ctrlx1;
                            coords[i++] = (float)this.ctrly1;
                        }
                        case 2: {
                            coords[i++] = (float)this.ctrlx2;
                            coords[i++] = (float)this.ctrly2;
                        }
                        case 1: {
                            coords[i++] = (float)this.x;
                            coords[i++] = (float)this.y;
                        }
                    }
                    break;
                }
            }
        }
        catch (TransformException cause) {
            IllegalPathStateException ex = new IllegalPathStateException(cause.getLocalizedMessage());
            ex.initCause(cause);
            throw ex;
        }
        return type;
    }

    private void derivativeAndTransform(double[] coords) throws TransformException {
        this.derivative = MathTransforms.derivativeAndTransform((MathTransform)this.projection, (double[])coords, (int)0, (double[])coords, (int)0);
        if (this.derivative == null) {
            throw new TransformException(Errors.format((short)5));
        }
        this.x = coords[0];
        this.y = coords[1];
    }

    private int transformSegment(double \u0394\u03bb, double \u0394\u03c6, double x1, double y1, Matrix D1) {
        double x2 = this.x;
        double y2 = this.y;
        Matrix D2 = this.derivative;
        double \u0394x = x2 - x1;
        double \u0394y = y2 - y1;
        double L12 = Math.hypot(\u0394x, \u0394y);
        double \u0394x1 = D1.getElement(0, 0) * \u0394\u03bb + D1.getElement(0, 1) * \u0394\u03c6;
        double \u0394y1 = D1.getElement(1, 0) * \u0394\u03bb + D1.getElement(1, 1) * \u0394\u03c6;
        double \u0394x2 = D2.getElement(0, 0) * \u0394\u03bb + D2.getElement(0, 1) * \u0394\u03c6;
        double \u0394y2 = D2.getElement(1, 0) * \u0394\u03bb + D2.getElement(1, 1) * \u0394\u03c6;
        double L1 = Math.hypot(\u0394x1, \u0394y1);
        double L2 = Math.hypot(\u0394x2, \u0394y2);
        double s1 = (\u0394x * \u0394x1 + \u0394y * \u0394y1) / (L12 * L1);
        double s2 = (\u0394x * \u0394x2 + \u0394y * \u0394y2) / (L12 * L2);
        if (!(Math.abs(Math.abs(s1) - 1.0) > 1.0E-5) && !(Math.abs(Math.abs(s2) - 1.0) > 1.0E-5)) {
            return 1;
        }
        if (s1 >= 0.7071067811865476 && Math.abs(s1 - s2) <= 1.0E-5) {
            double \u03b1 = Math.abs((\u0394y2 * \u0394x - \u0394x2 * \u0394y) / (\u0394y2 * \u0394x1 - \u0394x2 * \u0394y1));
            this.ctrlx2 = x1 + \u0394x1 * \u03b1;
            this.ctrly2 = y1 + \u0394y1 * \u03b1;
            return 2;
        }
        this.ctrlx1 = x1 + \u0394x1 / 3.0;
        this.ctrly1 = y1 + \u0394y1 / 3.0;
        this.ctrlx2 = x2 - \u0394x2 / 3.0;
        this.ctrly2 = y2 - \u0394y2 / 3.0;
        return 3;
    }
}

