/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.util.Arrays;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.lang.Static;

public final class Listeners
extends Static {
    private Listeners() {
    }

    public static ChangeListener[] addListener(ChangeListener listener, ChangeListener[] listeners) {
        ArgumentChecks.ensureNonNull((String)"listener", (Object)listener);
        if (listeners == null) {
            length = 0;
            listeners = new ChangeListener[1];
        } else {
            length = listeners.length;
            listeners = Arrays.copyOf(listeners, length + 1);
        }
        listeners[length] = listener;
        return listeners;
    }

    public static ChangeListener[] removeListener(ChangeListener listener, ChangeListener[] listeners) {
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                if (listeners[i] != listener) continue;
                if ((listeners = (ChangeListener[])ArraysExt.remove((Object[])listeners, (int)i, (int)1)).length != 0) break;
                listeners = null;
                break;
            }
        }
        return listeners;
    }

    public static void fireChanged(Object source, ChangeListener[] listeners) {
        if (listeners != null) {
            ChangeEvent event = new ChangeEvent(source);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(event);
            }
        }
    }
}

