/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.util.Static;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.content.CoverageDescription;
import org.opengis.metadata.identification.Identification;

public class MetadataUtilities
extends Static {
    private MetadataUtilities() {
    }

    public static String getIdentifier(Metadata metadata) {
        Collection identifications = metadata.getIdentificationInfo();
        for (Identification identification : identifications) {
            Iterator iterator;
            Citation citation = identification.getCitation();
            if (citation == null || !(iterator = citation.getIdentifiers().iterator()).hasNext()) continue;
            Identifier identifier = (Identifier)iterator.next();
            return identifier.getCode();
        }
        return null;
    }

    public static boolean addOnlineResource(Metadata target, URI resource) {
        DefaultDataIdentification info = null;
        boolean alreadySet = false;
        for (Identification tmp : target.getIdentificationInfo()) {
            if (tmp.getCitation() != null) {
                alreadySet = tmp.getCitation().getOnlineResources().stream().map(OnlineResource::getLinkage).anyMatch(resource::equals);
                if (alreadySet) break;
            }
            if (!(tmp instanceof DefaultDataIdentification)) continue;
            info = (DefaultDataIdentification)tmp;
            break;
        }
        if (!alreadySet) {
            if (info == null) {
                info = new DefaultDataIdentification();
                target.getIdentificationInfo().add(info);
            }
            DefaultCitation cit = new DefaultCitation();
            cit.getOnlineResources().add(new DefaultOnlineResource(resource));
            info.setCitation((Citation)cit);
        }
        return alreadySet;
    }

    public static Stream<CoverageDescription> extractCoverageDescription(Metadata source) {
        Stream<ContentInformation> cds = source.getContentInfo().stream().filter(info -> info instanceof CoverageDescription);
        return cds;
    }
}

