/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.process;

import java.util.Locale;
import org.apache.sis.util.Localized;
import org.apache.sis.util.SimpleInternationalString;
import org.geotoolkit.process.ProcessEvent;
import org.geotoolkit.process.ProcessListener;
import org.opengis.util.InternationalString;

public abstract class ProgressController
implements Localized,
ProcessListener {
    private final Locale locale = Locale.getDefault();
    private volatile InternationalString task;
    private volatile float progress;
    private volatile boolean canceled;

    protected ProgressController() {
    }

    public Locale getLocale() {
        return this.locale;
    }

    public InternationalString getTask() {
        return this.task;
    }

    public void setTask(CharSequence task) {
        if (task != null && !(task instanceof InternationalString)) {
            task = new SimpleInternationalString(task.toString());
        }
        this.task = (InternationalString)task;
    }

    public abstract void started();

    @Override
    public void started(ProcessEvent event) {
        this.started();
        this.progressing(event);
    }

    public abstract void paused();

    @Override
    public void paused(ProcessEvent event) {
        this.progressing(event);
        this.paused();
    }

    public abstract void resumed();

    @Override
    public void resumed(ProcessEvent event) {
        this.resumed();
        this.progressing(event);
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float percent) {
        if (percent < 0.0f) {
            percent = 0.0f;
        }
        if (percent > 100.0f) {
            percent = 100.0f;
        }
        this.progress = percent;
    }

    @Override
    public void progressing(ProcessEvent event) {
        if (event != null) {
            Exception ex;
            float progress;
            InternationalString task = event.getTask();
            if (task != null) {
                this.setTask((CharSequence)task);
            }
            if (!Float.isNaN(progress = event.getProgress())) {
                this.setProgress(progress);
            }
            if ((ex = event.getException()) != null) {
                this.exceptionOccurred(ex);
            }
        }
    }

    public abstract void completed();

    @Override
    public void completed(ProcessEvent event) {
        this.progressing(event);
        this.completed();
    }

    @Override
    public void failed(ProcessEvent event) {
        this.progressing(event);
    }

    @Override
    public void dismissed(ProcessEvent event) {
        this.canceled = true;
        this.failed(event);
    }

    public void cancel() {
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public abstract void warningOccurred(String var1, String var2, String var3);

    public abstract void exceptionOccurred(Throwable var1);
}

