/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.referencing.VerticalDatumTypes;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.Version;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class CRS
extends Static {
    private CRS() {
    }

    @Deprecated
    public static CoordinateOperationFactory getCoordinateOperationFactory() {
        return (CoordinateOperationFactory)DefaultFactories.forBuildin(CoordinateOperationFactory.class);
    }

    public static Version getVersion(String authority) throws FactoryRegistryException {
        String version;
        try {
            version = NameMeaning.getVersion((Citation)org.apache.sis.referencing.CRS.getAuthorityFactory((String)authority).getAuthority());
        }
        catch (FactoryException e) {
            throw new FactoryRegistryException(e.getLocalizedMessage(), e);
        }
        return version != null ? new Version(version) : null;
    }

    public static CompoundCRS getCompoundCRS(CompoundCRS crs, SingleCRS ... components) {
        List actualComponents = org.apache.sis.referencing.CRS.getSingleComponents((CoordinateReferenceSystem)crs);
        if (actualComponents.size() == components.length) {
            int firstValid = 0;
            SingleCRS[] toSearch = (SingleCRS[])components.clone();
            block0: for (SingleCRS component : actualComponents) {
                for (int i = firstValid; i < toSearch.length; ++i) {
                    if (!Utilities.equalsIgnoreMetadata((Object)component, (Object)toSearch[i])) continue;
                    System.arraycopy(toSearch, firstValid, toSearch, firstValid + 1, i - firstValid);
                    toSearch[firstValid++] = null;
                    continue block0;
                }
                firstValid = -1;
                break;
            }
            if (firstValid == toSearch.length) {
                return crs;
            }
        }
        for (CoordinateReferenceSystem component : crs.getComponents()) {
            CompoundCRS candidate;
            if (!(component instanceof CompoundCRS) || (candidate = CRS.getCompoundCRS((CompoundCRS)component, components)) == null) continue;
            return candidate;
        }
        return null;
    }

    public static CoordinateReferenceSystem getOrCreateSubCRS(CoordinateReferenceSystem crs, int lower, int upper) {
        if (crs == null) {
            return crs;
        }
        int dimension = crs.getCoordinateSystem().getDimension();
        if (lower < 0 || lower > upper || upper > dimension) {
            throw new IndexOutOfBoundsException(Errors.format((short)81, lower < 0 ? lower : upper));
        }
        if (lower == 0 && dimension == upper) {
            return crs;
        }
        if (!(crs instanceof CompoundCRS)) {
            return null;
        }
        ArrayList<CoordinateReferenceSystem> parts = new ArrayList<CoordinateReferenceSystem>(1);
        int res = CRS.decomposeCRS(crs, lower, upper, parts);
        if (res == -1) {
            return null;
        }
        int size = parts.size();
        if (size == 1) {
            return (CoordinateReferenceSystem)parts.get(0);
        }
        try {
            return org.apache.sis.referencing.CRS.compound((CoordinateReferenceSystem[])parts.toArray(new CoordinateReferenceSystem[size]));
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException("Illegal CRS.", e);
        }
    }

    private static int decomposeCRS(CoordinateReferenceSystem crs, int lower, int upper, List<CoordinateReferenceSystem> parts) {
        int dimension = crs.getCoordinateSystem().getDimension();
        if (lower == 0 && dimension <= upper) {
            parts.add(crs);
            return dimension;
        }
        if (lower >= dimension) {
            return dimension;
        }
        if (!(crs instanceof CompoundCRS)) {
            return -1;
        }
        int nbDimRead = 0;
        List components = ((CompoundCRS)crs).getComponents();
        for (CoordinateReferenceSystem component : components) {
            int res = CRS.decomposeCRS(component, lower, upper, parts);
            if (res == -1) {
                return -1;
            }
            nbDimRead += res;
            lower = Math.max(0, lower - res);
            if ((upper = Math.max(0, upper - res)) != 0) continue;
            break;
        }
        return nbDimRead;
    }

    public static Datum getDatum(CoordinateReferenceSystem crs) {
        Datum datum = null;
        if (crs instanceof SingleCRS) {
            datum = ((SingleCRS)crs).getDatum();
        } else if (crs instanceof CompoundCRS) {
            for (CoordinateReferenceSystem component : ((CompoundCRS)crs).getComponents()) {
                Datum candidate = CRS.getDatum(component);
                if (datum != null && !datum.equals(candidate)) {
                    if (CRS.isGeodetic3D(datum, candidate) || CRS.isGeodetic3D(candidate, datum)) continue;
                    return null;
                }
                datum = candidate;
            }
        }
        return datum;
    }

    private static boolean isGeodetic3D(Datum geodetic, Datum vertical) {
        return geodetic instanceof GeodeticDatum && vertical instanceof VerticalDatum && VerticalDatumTypes.ELLIPSOIDAL.equals(((VerticalDatum)vertical).getVerticalDatumType());
    }

    public static double[] deltaTransform(MathTransform transform, DirectPosition origin, double ... vector) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)transform);
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        double[] result = new double[targetDim];
        if (vector.length != sourceDim) {
            throw new IllegalArgumentException(Errors.format((short)95, "vector", vector.length, sourceDim));
        }
        if (transform instanceof AffineTransform) {
            ((AffineTransform)transform).deltaTransform(vector, 0, result, 0, 1);
        } else {
            int i;
            double[] coordinates = new double[2 * Math.max(sourceDim, targetDim)];
            for (i = 0; i < sourceDim; ++i) {
                double c = origin.getOrdinate(i);
                double d = vector[i] * 0.5;
                coordinates[i] = c - d;
                coordinates[i + sourceDim] = c + d;
            }
            transform.transform(coordinates, 0, coordinates, 0, 2);
            for (i = 0; i < targetDim; ++i) {
                result[i] = coordinates[i + targetDim] - coordinates[i];
            }
        }
        return result;
    }
}

