/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import javax.measure.Unit;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.parameter.AbstractParameterValue;
import org.geotoolkit.parameter.FloatParameter;
import org.geotoolkit.parameter.Parameter;
import org.geotoolkit.parameter.ParameterGroup;
import org.geotoolkit.referencing.operation.provider.MapProjectionDescriptor;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

@Deprecated
final class MapProjectionParameters
extends ParameterGroup {
    private static final long serialVersionUID = -6801091012335717139L;
    private transient ParameterValue<Double> earthRadius;
    private transient ParameterValue<Double> inverseFlattening;
    private transient ParameterValue<double[]> standardParallel;

    MapProjectionParameters(MapProjectionDescriptor descriptor) {
        super((ParameterDescriptorGroup)descriptor);
    }

    final double get(ParameterDescriptor<Double> parameter) {
        return (Double)Parameters.castOrWrap((ParameterValueGroup)this).getValue(parameter);
    }

    final void set(ParameterDescriptor<Double> parameter, double value, Unit<?> unit) {
        Parameters.castOrWrap((ParameterValueGroup)this).getOrCreate(parameter).setValue(value, unit);
    }

    @Override
    public ParameterValue<?> parameter(String name) throws ParameterNotFoundException {
        name = name.trim();
        int supplement = ((MapProjectionDescriptor)this.getDescriptor()).supplement;
        if ((supplement & 1) != 0) {
            if (name.equalsIgnoreCase("earth_radius")) {
                EarthRadius value = this.earthRadius;
                if (value == null) {
                    value = this.earthRadius = new EarthRadius();
                }
                return value;
            }
            if (name.equalsIgnoreCase("inverse_flattening")) {
                InverseFlattening value = this.inverseFlattening;
                if (value == null) {
                    value = this.inverseFlattening = new InverseFlattening();
                }
                return value;
            }
        }
        if ((supplement & 2) != 0 && name.equalsIgnoreCase("standard_parallel")) {
            StandardParallel value = this.standardParallel;
            if (value == null) {
                value = this.standardParallel = new StandardParallel();
            }
            return value;
        }
        return super.parameter(name);
    }

    private final class EarthRadius
    extends FloatParameter {
        private static final long serialVersionUID = 5848432458976184182L;

        EarthRadius() {
            super(UniversalParameters.EARTH_RADIUS);
        }

        @Override
        public double doubleValue() {
            return Formulas.getAuthalicRadius((double)MapProjectionParameters.this.get((ParameterDescriptor<Double>)UniversalParameters.SEMI_MAJOR), (double)MapProjectionParameters.this.get((ParameterDescriptor<Double>)UniversalParameters.SEMI_MINOR));
        }

        @Override
        public void setValue(double value, Unit<?> unit) {
            super.setValue(value, unit);
            MapProjectionParameters.this.set((ParameterDescriptor<Double>)UniversalParameters.SEMI_MAJOR, value, unit);
            MapProjectionParameters.this.set((ParameterDescriptor<Double>)UniversalParameters.SEMI_MINOR, value, unit);
        }
    }

    private final class InverseFlattening
    extends FloatParameter
    implements ChangeListener {
        private static final long serialVersionUID = 4490056024453509851L;

        InverseFlattening() {
            super(UniversalParameters.INVERSE_FLATTENING);
        }

        @Override
        public double doubleValue() {
            double semiMinorAxis;
            double semiMajorAxis = MapProjectionParameters.this.get((ParameterDescriptor<Double>)UniversalParameters.SEMI_MAJOR);
            double ivf = semiMajorAxis / (semiMajorAxis - (semiMinorAxis = MapProjectionParameters.this.get((ParameterDescriptor<Double>)UniversalParameters.SEMI_MINOR)));
            if (Double.isNaN(ivf)) {
                ivf = super.doubleValue();
            }
            return ivf;
        }

        @Override
        public void setValue(double value, Unit<?> unit) {
            boolean wasNull = Double.isNaN(super.doubleValue());
            super.setValue(value, unit);
            ParameterValue<?> semiMajor = MapProjectionParameters.this.parameter("semi_major");
            if (Double.isNaN(value)) {
                if (!wasNull && semiMajor instanceof AbstractParameterValue) {
                    ((AbstractParameterValue)semiMajor).removeChangeListener(this);
                }
            } else {
                if (wasNull && semiMajor instanceof AbstractParameterValue) {
                    ((AbstractParameterValue)semiMajor).addChangeListener(this);
                }
                this.update(value);
            }
        }

        private void update(double value) {
            ParameterValue semiMajor;
            try {
                semiMajor = Parameters.castOrWrap((ParameterValueGroup)MapProjectionParameters.this).getOrCreate((ParameterDescriptor)UniversalParameters.SEMI_MAJOR);
            }
            catch (IllegalStateException e) {
                return;
            }
            MapProjectionParameters.this.set((ParameterDescriptor<Double>)UniversalParameters.SEMI_MINOR, semiMajor.doubleValue() * (1.0 - 1.0 / value), semiMajor.getUnit());
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            this.update(super.doubleValue());
        }
    }

    private final class StandardParallel
    extends Parameter<double[]> {
        private static final long serialVersionUID = -1379566730374843040L;

        StandardParallel() {
            super(UniversalParameters.STANDARD_PARALLEL);
        }

        @Override
        public double[] getValue() {
            double standardParallel1 = MapProjectionParameters.this.get((ParameterDescriptor<Double>)UniversalParameters.STANDARD_PARALLEL_1);
            double standardParallel2 = MapProjectionParameters.this.get((ParameterDescriptor<Double>)UniversalParameters.STANDARD_PARALLEL_2);
            if (Double.isNaN(standardParallel2)) {
                double[] dArray;
                if (Double.isNaN(standardParallel1)) {
                    dArray = ArraysExt.EMPTY_DOUBLE;
                } else {
                    double[] dArray2 = new double[1];
                    dArray = dArray2;
                    dArray2[0] = standardParallel1;
                }
                return dArray;
            }
            return new double[]{standardParallel1, standardParallel2};
        }

        @Override
        protected void setSafeValue(double[] value, Unit<?> unit) {
            double standardParallel1 = Double.NaN;
            double standardParallel2 = Double.NaN;
            if (value != null) {
                switch (value.length) {
                    default: {
                        throw new IllegalArgumentException(Errors.format((short)52, "standard_parallel"));
                    }
                    case 2: {
                        standardParallel2 = value[1];
                    }
                    case 1: {
                        standardParallel1 = value[0];
                    }
                    case 0: 
                }
            }
            MapProjectionParameters.this.set((ParameterDescriptor<Double>)UniversalParameters.STANDARD_PARALLEL_1, standardParallel1, unit);
            MapProjectionParameters.this.set((ParameterDescriptor<Double>)UniversalParameters.STANDARD_PARALLEL_2, standardParallel2, unit);
        }
    }
}

