/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.parser;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.policy.AlternativeSelector;
import com.sun.xml.ws.api.policy.PolicyResolver;
import com.sun.xml.ws.api.policy.PolicyResolverFactory;
import com.sun.xml.ws.api.policy.ValidationProcessor;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.EffectivePolicyModifier;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapExtender;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicyMapMutator;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.localization.LocalizationMessages;
import com.sun.xml.ws.policy.parser.PolicyConfigParser;
import com.sun.xml.ws.policy.spi.PolicyAssertionValidator;
import jakarta.xml.ws.WebServiceException;
import java.net.URL;
import java.util.Collection;
import javax.xml.stream.FactoryConfigurationError;

public class WsitPolicyResolver
implements PolicyResolver {
    private static final Logger LOGGER = Logger.getLogger(WsitPolicyResolver.class);

    @Override
    public PolicyMap resolve(PolicyResolver.ServerContext context) throws WebServiceException {
        String configId;
        Class endpointClass = context.getEndpointClass();
        String string = configId = endpointClass == null ? null : endpointClass.getName();
        if (!context.hasWsdl()) {
            PolicyMap map = null;
            try {
                Collection<PolicyMapMutator> mutators = context.getMutators();
                map = PolicyConfigParser.parse(configId, context.getContainer(), mutators.toArray(new PolicyMapMutator[0]));
            }
            catch (PolicyException e) {
                throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_5006_FAILED_TO_READ_WSIT_CONFIG_FOR_ID(configId), (Throwable)e));
            }
            if (map == null) {
                LOGGER.config(LocalizationMessages.WSP_5008_CREATE_POLICY_MAP_FOR_CONFIG(configId));
            } else {
                WsitPolicyResolver.validateServerPolicyMap(map);
            }
            return map;
        }
        try {
            URL wsitConfigFile;
            if (configId != null && (wsitConfigFile = PolicyConfigParser.findConfigFile(configId, context.getContainer())) != null) {
                LOGGER.warning(LocalizationMessages.WSP_5024_WSIT_CONFIG_AND_WSDL(wsitConfigFile));
            }
            return PolicyResolverFactory.DEFAULT_POLICY_RESOLVER.resolve(context);
        }
        catch (PolicyException e) {
            throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_5023_FIND_WSIT_CONFIG_FAILED(), (Throwable)e));
        }
    }

    @Override
    public PolicyMap resolve(PolicyResolver.ClientContext context) {
        PolicyMap effectivePolicyMap;
        try {
            PolicyMap clientConfigPolicyMap = PolicyConfigParser.parse("client", context.getContainer(), new PolicyMapMutator[0]);
            if (clientConfigPolicyMap == null) {
                LOGGER.config(LocalizationMessages.WSP_5014_CLIENT_CONFIG_PROCESSING_SKIPPED());
                effectivePolicyMap = context.getPolicyMap();
            } else {
                effectivePolicyMap = WsitPolicyResolver.mergePolicyMap(context.getPolicyMap(), clientConfigPolicyMap);
            }
        }
        catch (PolicyException e) {
            throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_5004_ERROR_WHILE_PROCESSING_CLIENT_CONFIG(), (Throwable)e));
        }
        if (effectivePolicyMap != null) {
            return WsitPolicyResolver.doAlternativeSelection(effectivePolicyMap);
        }
        return null;
    }

    private static void validateServerPolicyMap(PolicyMap policyMap) {
        try {
            ValidationProcessor validationProcessor = ValidationProcessor.getInstance();
            for (Policy policy : policyMap) {
                for (AssertionSet assertionSet : policy) {
                    for (PolicyAssertion assertion : assertionSet) {
                        PolicyAssertionValidator.Fitness validationResult = validationProcessor.validateServerSide(assertion);
                        if (validationResult == PolicyAssertionValidator.Fitness.SUPPORTED) continue;
                        throw new PolicyException(LocalizationMessages.WSP_5017_SERVER_SIDE_ASSERTION_VALIDATION_FAILED(assertion.getName(), (Object)validationResult));
                    }
                }
            }
        }
        catch (PolicyException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private static PolicyMap doAlternativeSelection(PolicyMap policyMap) {
        EffectivePolicyModifier modifier = EffectivePolicyModifier.createEffectivePolicyModifier();
        modifier.connect(policyMap);
        try {
            AlternativeSelector.doSelection(modifier);
        }
        catch (PolicyException e) {
            throw new WebServiceException((Throwable)e);
        }
        finally {
            modifier.disconnect();
        }
        return policyMap;
    }

    private static PolicyMap mergePolicyMap(PolicyMap policyMap, PolicyMap clientPolicyMap) throws PolicyException {
        PolicyMapExtender mapExtender = PolicyMapExtender.createPolicyMapExtender();
        String clientWsitConfigId = "client";
        if (policyMap != null) {
            mapExtender.connect(policyMap);
            try {
                Policy policy;
                for (PolicyMapKey key : clientPolicyMap.getAllServiceScopeKeys()) {
                    policy = clientPolicyMap.getServiceEffectivePolicy(key);
                    mapExtender.putServiceSubject(key, new PolicySubject((Object)"client", policy));
                }
                for (PolicyMapKey key : clientPolicyMap.getAllEndpointScopeKeys()) {
                    policy = clientPolicyMap.getEndpointEffectivePolicy(key);
                    mapExtender.putEndpointSubject(key, new PolicySubject((Object)"client", policy));
                }
                for (PolicyMapKey key : clientPolicyMap.getAllOperationScopeKeys()) {
                    policy = clientPolicyMap.getOperationEffectivePolicy(key);
                    mapExtender.putOperationSubject(key, new PolicySubject((Object)"client", policy));
                }
                for (PolicyMapKey key : clientPolicyMap.getAllInputMessageScopeKeys()) {
                    policy = clientPolicyMap.getInputMessageEffectivePolicy(key);
                    mapExtender.putInputMessageSubject(key, new PolicySubject((Object)"client", policy));
                }
                for (PolicyMapKey key : clientPolicyMap.getAllOutputMessageScopeKeys()) {
                    policy = clientPolicyMap.getOutputMessageEffectivePolicy(key);
                    mapExtender.putOutputMessageSubject(key, new PolicySubject((Object)"client", policy));
                }
                for (PolicyMapKey key : clientPolicyMap.getAllFaultMessageScopeKeys()) {
                    policy = clientPolicyMap.getFaultMessageEffectivePolicy(key);
                    mapExtender.putFaultMessageSubject(key, new PolicySubject((Object)"client", policy));
                }
                LOGGER.fine(LocalizationMessages.WSP_5015_CLIENT_CFG_POLICIES_TRANSFERED_INTO_FINAL_POLICY_MAP(policyMap));
            }
            catch (FactoryConfigurationError ex) {
                throw LOGGER.logSevereException(new PolicyException(ex));
            }
            return policyMap;
        }
        return clientPolicyMap;
    }
}

