/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.spi;

import java.io.IOException;
import java.io.PrintStream;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.basic.fsm.FSMImpl;
import org.glassfish.pfl.basic.fsm.Input;
import org.glassfish.pfl.basic.fsm.Runner;
import org.glassfish.pfl.basic.fsm.State;
import org.glassfish.pfl.basic.fsm.StateEngine;
import org.glassfish.pfl.dynamic.codegen.impl.BlockStatement;
import org.glassfish.pfl.dynamic.codegen.impl.ClassGeneratorImpl;
import org.glassfish.pfl.dynamic.codegen.impl.CodeGenerator;
import org.glassfish.pfl.dynamic.codegen.impl.CodeGeneratorUtil;
import org.glassfish.pfl.dynamic.codegen.impl.CurrentClassLoader;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionFactory;
import org.glassfish.pfl.dynamic.codegen.impl.FieldGenerator;
import org.glassfish.pfl.dynamic.codegen.impl.Identifier;
import org.glassfish.pfl.dynamic.codegen.impl.IfStatement;
import org.glassfish.pfl.dynamic.codegen.impl.ImportListImpl;
import org.glassfish.pfl.dynamic.codegen.impl.MethodGenerator;
import org.glassfish.pfl.dynamic.codegen.impl.SwitchStatement;
import org.glassfish.pfl.dynamic.codegen.impl.TryStatement;
import org.glassfish.pfl.dynamic.codegen.impl.Util;
import org.glassfish.pfl.dynamic.codegen.impl.WhileStatement;
import org.glassfish.pfl.dynamic.codegen.spi.ClassGenerator;
import org.glassfish.pfl.dynamic.codegen.spi.Expression;
import org.glassfish.pfl.dynamic.codegen.spi.FieldInfo;
import org.glassfish.pfl.dynamic.codegen.spi.ImportList;
import org.glassfish.pfl.dynamic.codegen.spi.Signature;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Variable;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopierOrdinaryImpl;

public final class Wrapper {
    private static final State S_INIT = new State("S_INIT", State.Kind.INITIAL);
    private static final State S_DONE = new State("S_DONE", State.Kind.FINAL);
    private static final State S_PACKAGE = new State("S_PACKAGE");
    private static final State S_CLASS = new State("S_CLASS", State.Kind.INITIAL);
    private static final State S_METHOD = new State("S_METHOD", State.Kind.INITIAL);
    private static final State S_BODY = new State("S_BODY", State.Kind.INITIAL);
    private static final State S_IF = new State("S_IF", State.Kind.INITIAL);
    private static final State S_ELSE = new State("S_ELSE");
    private static final State S_TRY = new State("S_TRY", State.Kind.INITIAL);
    private static final State S_FINAL = new State("S_FINAL");
    private static final State S_SWITCH = new State("S_SWITCH", State.Kind.INITIAL);
    private static final State S_DEFAULT = new State("S_DEFAULT");
    private static final StateEngine engine = StateEngine.create();
    private static ThreadLocal<Environment> tl;
    private static final String CODEGEN_PREFIX = "org.glassfish.dynamic.codegen";
    private static final String DEBUG_PREFIX = "org.glassfish.dynamic.codegen.debug";
    public static final String CLASS_GENERATION_DIRECTORY = "org.glassfish.dynamic.codegen.classGenerationDirectory";
    public static final String SOURCE_GENERATION_DIRECTORY = "org.glassfish.dynamic.codegen.sourceGenerationDirectory";
    public static final String DUMP_AFTER_SETUP_VISITOR = "org.glassfish.dynamic.codegen.debug.dumpAfterSetupVisitor";
    public static final String TRACE_BYTE_CODE_GENERATION = "org.glassfish.dynamic.codegen.debug.traceByteCodeGeneration";
    public static final String DUMP_CONSTANT_POOL = "org.glassfish.dynamic.codegen.debug.dumpConstantPool";
    public static final String USE_ASM_VERIFIER = "org.glassfish.dynamic.codegen.debug.useAsmVerifier";

    private Wrapper() {
    }

    private static void addCommonTransitions(State state) {
        engine.add(state, Operation.SIMPLE, null, state);
        engine.add(state, Operation.IF, null, state);
        engine.add(state, Operation.TRY, null, state);
        engine.add(state, Operation.SWITCH, null, state);
        engine.add(state, Operation.WHILE, null, state);
        engine.add(state, Operation.END, null, S_DONE);
    }

    private static Environment env() {
        return tl.get();
    }

    public static ClassGenerator _classGenerator() {
        return Wrapper.env().classGenerator();
    }

    public static void _setClassLoader(ClassLoader cl) {
        CurrentClassLoader.set(cl);
    }

    public static byte[] _byteCode(ClassLoader cl, Properties options) {
        return Wrapper._byteCode(Wrapper.env().classGenerator(), cl, options);
    }

    public static byte[] _byteCode(ClassGenerator cgen, ClassLoader cl, Properties options) {
        ClassGeneratorImpl cg = Wrapper.env().classGenerator();
        ImportList imports = Wrapper.env().imports();
        return CodeGenerator.generateBytecode(cg, cl, imports, options, System.out);
    }

    public static Class<?> _generate(ClassLoader cl, ProtectionDomain pd, Properties props, PrintStream ps) {
        ClassGeneratorImpl cg = Wrapper.env().classGenerator();
        return Wrapper._generate(cg, cl, pd, props, ps);
    }

    public static Class<?> _generate(ClassLoader cl, ProtectionDomain pd, Properties props) {
        ClassGeneratorImpl cg = Wrapper.env().classGenerator();
        return Wrapper._generate(cg, cl, pd, props, System.out);
    }

    private static Class<?> _generate(ClassGenerator cg, ClassLoader cl, ProtectionDomain pd, Properties props, PrintStream ps) {
        ImportList imports = Wrapper.env().imports();
        byte[] data = CodeGenerator.generateBytecode((ClassGeneratorImpl)cg, cl, imports, props, ps);
        return CodeGeneratorUtil.makeClass(cg.name(), data, pd, cl);
    }

    public static Class<?> _generate(Class<?> anchorClass, Properties props, PrintStream ps) {
        return Wrapper._generate(Wrapper.env().classGenerator(), anchorClass, props, ps);
    }

    public static Class<?> _generate(Class<?> anchorClass, Properties props) {
        return Wrapper._generate(Wrapper.env().classGenerator(), anchorClass, props, System.out);
    }

    private static Class<?> _generate(ClassGenerator cg, Class<?> anchorClass, Properties props, PrintStream ps) {
        ImportList imports = Wrapper.env().imports();
        byte[] data = CodeGenerator.generateBytecode((ClassGeneratorImpl)cg, anchorClass.getClassLoader(), imports, props, ps);
        return CodeGeneratorUtil.makeClass(cg.name(), data, anchorClass);
    }

    public static void _sourceCode(PrintStream ps, Properties options) throws IOException {
        ClassGeneratorImpl cg = Wrapper.env().classGenerator();
        Wrapper._sourceCode(cg, ps, options);
    }

    public static void _sourceCode(ClassGenerator cg, PrintStream ps, Properties options) throws IOException {
        ImportList imports = Wrapper.env().imports();
        CodeGenerator.generateSourceCode(ps, (ClassGeneratorImpl)cg, imports, options);
    }

    public static void _sourceCode(Properties options) throws IOException {
        ClassGeneratorImpl cg = Wrapper.env().classGenerator();
        Wrapper._sourceCode(cg, options);
    }

    public static void _sourceCode(ClassGenerator cg, Properties options) throws IOException {
        ImportList imports = Wrapper.env().imports();
        String sourceGenDir = options.getProperty(SOURCE_GENERATION_DIRECTORY);
        if (sourceGenDir == null) {
            throw new IllegalArgumentException("options must specify SOURCE_GENERATION_DIRECTORY");
        }
        CodeGenerator.generateSourceCode(sourceGenDir, (ClassGeneratorImpl)cg, imports, options);
    }

    public static void _displayAST(ClassGenerator cg, PrintStream ps) {
        Util.display((ClassGeneratorImpl)cg, ps);
    }

    public static void _clear() {
        Wrapper.env()._clear();
    }

    public static Signature _s(Type rtype, Type ... types) {
        return Signature.make(rtype, Arrays.asList(types));
    }

    public static Signature _s(Type rtype, List<Type> types) {
        return Signature.make(rtype, types);
    }

    public static Type _t(String name) {
        return Wrapper.env()._t(name);
    }

    public static Type _void() {
        return Type._void();
    }

    public static Type _boolean() {
        return Type._boolean();
    }

    static Type _byte() {
        return Type._byte();
    }

    static Type _short() {
        return Type._short();
    }

    static Type _char() {
        return Type._char();
    }

    public static Type _int() {
        return Type._int();
    }

    static Type _long() {
        return Type._long();
    }

    static Type _float() {
        return Type._float();
    }

    static Type _double() {
        return Type._double();
    }

    public static Type _Object() {
        return Type._Object();
    }

    public static Type _String() {
        return Type._String();
    }

    public static Type _Class() {
        return Type._Class();
    }

    public static Pair<String, String> splitClassName(String name) {
        int lastDot = name.lastIndexOf(46);
        String pname = lastDot == -1 ? "" : name.substring(0, lastDot);
        String cname = name.substring(lastDot + 1);
        return new Pair<String, String>(pname, cname);
    }

    public static void _package(String name) {
        Wrapper.env()._package(name);
    }

    public static void _package() {
        Wrapper.env()._package("");
    }

    public static Type _import(String name) {
        return Wrapper.env()._import(name);
    }

    public static ImportList _import() {
        return Wrapper.env()._import();
    }

    public static void _import(ImportList ilist) {
        Wrapper.env()._import(ilist);
    }

    public static void _class(int modifiers, String name, Type superClass, Type ... impls) {
        Wrapper.env()._class(modifiers, name, superClass, Arrays.asList(impls));
    }

    public static void _class(int modifiers, String name, Type superClass, List<Type> impls) {
        Wrapper.env()._class(modifiers, name, superClass, impls);
    }

    public static void _interface(int modifiers, String name, Type ... impls) {
        Wrapper.env()._interface(modifiers, name, Arrays.asList(impls));
    }

    public static void _interface(int modifiers, String name, List<Type> impls) {
        Wrapper.env()._interface(modifiers, name, impls);
    }

    public static Expression _data(int modifiers, Type type, String name) {
        FieldGenerator fld = Wrapper.env()._data(modifiers, type, name);
        return fld.getExpression();
    }

    public static void _method(int modifiers, Type type, String name, Type ... exceptions) {
        Wrapper.env()._method(modifiers, type, name, Arrays.asList(exceptions));
    }

    public static void _method(int modifiers, Type type, String name, List<Type> exceptions) {
        Wrapper.env()._method(modifiers, type, name, exceptions);
    }

    public static void _constructor(int modifiers, Type ... exceptions) {
        Wrapper.env()._constructor(modifiers, Arrays.asList(exceptions));
    }

    public static void _constructor(int modifiers, List<Type> exceptions) {
        Wrapper.env()._constructor(modifiers, exceptions);
    }

    public static Expression _arg(Type type, String name) {
        return Wrapper.env()._arg(type, name);
    }

    public static void _body() {
        Wrapper.env()._body();
    }

    public static void _end() {
        Wrapper.env()._end();
    }

    public static void _expr(Expression expr) {
        Wrapper.env().bs().addExpression(expr);
    }

    public static void _assign(Expression var, Expression expr) {
        Wrapper.env().bs().addAssign(var, expr);
    }

    public static Expression _define(Type type, String name, Expression expr) {
        return Wrapper.env().bs().addDefinition(type, name, expr);
    }

    public static void _return() {
        Wrapper.env().bs().addReturn();
    }

    public static void _return(Expression expr) {
        Wrapper.env().bs().addReturn(expr);
    }

    public static void _throw(Expression expr) {
        Wrapper.env().bs().addThrow(expr);
    }

    public static void _if(Expression expr) {
        Wrapper.env()._if(expr);
    }

    public static void _else() {
        Wrapper.env()._else();
    }

    public static void _try() {
        Wrapper.env()._try();
    }

    public static Expression _catch(Type type, String name) {
        return Wrapper.env()._catch(type, name);
    }

    public static void _finally() {
        Wrapper.env()._finally();
    }

    public static Expression _v(String name) {
        return Wrapper.env()._v(name);
    }

    public static Expression _null() {
        return Wrapper.env().ef()._null();
    }

    public static Expression _const(boolean c) {
        return Wrapper.env().ef()._const(c);
    }

    public static Expression _const(char c) {
        return Wrapper.env().ef()._const(c);
    }

    public static Expression _const(byte c) {
        return Wrapper.env().ef()._const(c);
    }

    public static Expression _const(short c) {
        return Wrapper.env().ef()._const(c);
    }

    public static Expression _const(int c) {
        return Wrapper.env().ef()._const(c);
    }

    public static Expression _const(long c) {
        return Wrapper.env().ef()._const(c);
    }

    public static Expression _const(float c) {
        return Wrapper.env().ef()._const(c);
    }

    public static Expression _const(double c) {
        return Wrapper.env().ef()._const(c);
    }

    public static Expression _const(String c) {
        return Wrapper.env().ef()._const(c);
    }

    public static Expression _const(Type c) {
        return Wrapper.env().ef()._const(c);
    }

    public static Expression _call(Expression target, String ident, Signature signature, Expression ... args) {
        return Wrapper.env().ef().call(target, ident, signature, Arrays.asList(args));
    }

    public static Expression _call(Expression target, String ident, Signature signature, List<Expression> args) {
        return Wrapper.env().ef().call(target, ident, signature, args);
    }

    public static Expression _call(Expression target, String ident, Expression ... args) {
        return Wrapper.env().ef().call(target, ident, Arrays.asList(args));
    }

    public static Expression _call(Expression target, String ident, List<Expression> args) {
        return Wrapper.env().ef().call(target, ident, args);
    }

    public static Expression _call(Type target, String ident, Signature signature, Expression ... args) {
        return Wrapper.env().ef().staticCall(target, ident, signature, Arrays.asList(args));
    }

    public static Expression _call(Type target, String ident, Signature signature, List<Expression> args) {
        return Wrapper.env().ef().staticCall(target, ident, signature, args);
    }

    public static Expression _call(Type target, String ident, Expression ... args) {
        return Wrapper.env().ef().staticCall(target, ident, Arrays.asList(args));
    }

    public static Expression _call(Type target, String ident, List<Expression> args) {
        return Wrapper.env().ef().staticCall(target, ident, args);
    }

    public static Expression _super(String ident, Signature signature, Expression ... exprs) {
        return Wrapper.env().ef().superCall(ident, signature, Arrays.asList(exprs));
    }

    public static Expression _super(String ident, Signature signature, List<Expression> exprs) {
        return Wrapper.env().ef().superCall(ident, signature, exprs);
    }

    public static Expression _super(String ident, Expression ... exprs) {
        return Wrapper.env().ef().superCall(ident, Arrays.asList(exprs));
    }

    public static Expression _super(String ident, List<Expression> exprs) {
        return Wrapper.env().ef().superCall(ident, exprs);
    }

    public static Expression _super(Signature signature, Expression ... exprs) {
        return Wrapper.env().ef().superObj(signature, Arrays.asList(exprs));
    }

    public static Expression _super(Signature signature, List<Expression> exprs) {
        return Wrapper.env().ef().superObj(signature, exprs);
    }

    public static Expression _super(List<Expression> exprs) {
        return Wrapper.env().ef().superObj(exprs);
    }

    public static Expression _super(Expression ... exprs) {
        return Wrapper.env().ef().superObj(Arrays.asList(exprs));
    }

    public static Expression _this(Signature signature, Expression ... exprs) {
        return Wrapper.env().ef().thisObj(signature, Arrays.asList(exprs));
    }

    public static Expression _this(Signature signature, List<Expression> exprs) {
        return Wrapper.env().ef().thisObj(signature, exprs);
    }

    public static Expression _this(Expression ... exprs) {
        return Wrapper.env().ef().thisObj(Arrays.asList(exprs));
    }

    public static Expression _this(List<Expression> exprs) {
        return Wrapper.env().ef().thisObj(exprs);
    }

    private static Expression _binary(Expression left, ExpressionFactory.BinaryOperator op, Expression right) {
        return Wrapper.env().ef().binaryOperator(left, op, right);
    }

    public static Expression _ne(Expression left, Expression right) {
        return Wrapper._binary(left, ExpressionFactory.BinaryOperator.NE, right);
    }

    public static Expression _cast(Type type, Expression expr) {
        return Wrapper.env().ef().cast(type, expr);
    }

    public static Expression _new(Type type, Signature signature, Expression ... args) {
        return Wrapper.env().ef().newObj(type, signature, Arrays.asList(args));
    }

    public static Expression _new(Type type, Signature signature, List<Expression> args) {
        return Wrapper.env().ef().newObj(type, signature, args);
    }

    public static Expression _new(Type type, Expression ... args) {
        return Wrapper.env().ef().newObj(type, Arrays.asList(args));
    }

    public static Expression _new(Type type, List<Expression> args) {
        return Wrapper.env().ef().newObj(type, args);
    }

    public static Expression _new_array_init(Type type, Expression ... args) {
        return Wrapper.env().ef().newArrInit(type, Arrays.asList(args));
    }

    public static Expression _new_array_init(Type type, List<Expression> args) {
        return Wrapper.env().ef().newArrInit(type, args);
    }

    public static Type _thisClass() {
        return Wrapper.env()._thisClass();
    }

    public static Expression _this() {
        return Wrapper.env().ef()._this();
    }

    public static Expression _field(Expression expr, String fieldName) {
        return Wrapper.env().ef().fieldAccess(expr, fieldName);
    }

    public static Expression _field(Type type, String fieldName) {
        return Wrapper.env().ef().fieldAccess(type, fieldName);
    }

    public static Expression _index(Expression expr, Expression index) {
        return Wrapper.env().ef().arrayIndex(expr, index);
    }

    static {
        engine.add(S_INIT, Operation.PACKAGE, null, S_PACKAGE);
        engine.add(S_PACKAGE, Operation.IMPORT, null, S_PACKAGE);
        engine.add(S_PACKAGE, Operation.CLASS, null, S_CLASS);
        engine.add(S_CLASS, Operation.DATA, null, S_CLASS);
        engine.add(S_CLASS, Operation.INITIALIZER, null, S_CLASS);
        engine.add(S_CLASS, Operation.METHOD, null, S_CLASS);
        engine.add(S_CLASS, Operation.END, null, S_DONE);
        engine.add(S_METHOD, Operation.BODY, null, S_BODY);
        engine.add(S_METHOD, Operation.ARG, null, S_METHOD);
        engine.add(S_METHOD, Operation.END, null, S_DONE);
        Wrapper.addCommonTransitions(S_BODY);
        Wrapper.addCommonTransitions(S_IF);
        engine.add(S_IF, Operation.ELSE, null, S_ELSE);
        Wrapper.addCommonTransitions(S_ELSE);
        Wrapper.addCommonTransitions(S_TRY);
        engine.add(S_TRY, Operation.CATCH, null, S_TRY);
        engine.add(S_TRY, Operation.FINALLY, null, S_FINAL);
        Wrapper.addCommonTransitions(S_FINAL);
        Wrapper.addCommonTransitions(S_SWITCH);
        engine.add(S_SWITCH, Operation.CASE, null, S_SWITCH);
        engine.add(S_SWITCH, Operation.DEFAULT, null, S_DEFAULT);
        Wrapper.addCommonTransitions(S_DEFAULT);
        tl = ThreadLocal.withInitial(Environment::new);
    }

    private static enum Operation implements Input
    {
        PACKAGE,
        IMPORT,
        CLASS,
        DATA,
        INITIALIZER,
        METHOD,
        ARG,
        BODY,
        IF,
        ELSE,
        TRY,
        CATCH,
        FINALLY,
        SWITCH,
        CASE,
        DEFAULT,
        WHILE,
        SIMPLE,
        END;

    }

    private static class Environment {
        private Stack<Context> contexts;
        private ImportList imports;
        private String _package;
        private ClassGeneratorImpl root;

        ImportList imports() {
            return this.imports;
        }

        private <T extends Context> T top(Class<T> cls) {
            return (T)((Context)cls.cast(this.contexts.peek()));
        }

        Environment() {
            this._clear();
        }

        void _clear() {
            this.contexts = new Stack();
            this.contexts.push(new PackageContext(this.contexts));
            this.imports = new ImportListImpl();
            this._package = "";
            this.root = null;
        }

        Type _t(String name) {
            Type type = this.imports.lookup(name);
            if (type == null) {
                return Type._class(name);
            }
            return type;
        }

        Expression _v(String name) {
            return this.contexts.peek().getVariable(name);
        }

        ClassGeneratorImpl classGenerator() {
            return this.root;
        }

        Type _thisClass() {
            return this.root.thisType();
        }

        ExpressionFactory ef() {
            return this.contexts.peek().ef();
        }

        BlockStatement bs() {
            return this.contexts.peek().bs();
        }

        private void checkState(Operation op) {
            this.contexts.peek().stateTransition(op);
        }

        final void _package(String name) {
            this.checkState(Operation.PACKAGE);
            if (!"".equals(name)) {
                Identifier.isValidFullIdentifier(name);
            }
            this._package = name;
        }

        final Type _import(String name) {
            this.checkState(Operation.IMPORT);
            Type type = Type._class(name);
            Type itype = this.imports.lookup(type.className());
            if (itype == null) {
                this.imports.addImport(type);
            } else if (!type.equals(itype)) {
                throw new IllegalArgumentException(type.name() + " conflicts with " + itype.name());
            }
            return type;
        }

        final void _import(ImportList importList) {
            this.checkState(Operation.IMPORT);
            this.imports = importList.copy();
        }

        final ImportList _import() {
            this.checkState(Operation.IMPORT);
            return this.imports.copy();
        }

        public final void _class(int modifiers, String name, Type superClass, List<Type> impls) {
            this.checkState(Operation.CLASS);
            Object cname = name;
            if (!this._package.equals("")) {
                cname = this._package + "." + name;
            }
            this.root = CodeGenerator.defineClass(modifiers, (String)cname, superClass, impls);
            new ClassContext(this.contexts, this.root);
        }

        final void _interface(int modifiers, String name, List<Type> impls) {
            this.checkState(Operation.CLASS);
            Object cname = name;
            if (!this._package.equals("")) {
                cname = this._package + "." + name;
            }
            this.root = CodeGenerator.defineInterface(modifiers, (String)cname, impls);
            new ClassContext(this.contexts, this.root);
        }

        final FieldGenerator _data(int modifiers, Type type, String name) {
            this.checkState(Operation.DATA);
            ClassContext cc = this.top(ClassContext.class);
            return cc._data(modifiers, type, name);
        }

        final void _method(int modifiers, Type type, String name, List<Type> exceptions) {
            this.checkState(Operation.METHOD);
            ClassContext cc = this.top(ClassContext.class);
            cc._method(modifiers, type, name, exceptions);
        }

        final void _constructor(int modifiers, List<Type> exceptions) {
            this.checkState(Operation.METHOD);
            ClassContext cc = this.top(ClassContext.class);
            cc._constructor(modifiers, exceptions);
        }

        final Expression _arg(Type type, String name) {
            this.checkState(Operation.ARG);
            MethodContext mc = this.top(MethodContext.class);
            return mc._arg(type, name);
        }

        final void _body() {
            this.checkState(Operation.BODY);
            MethodContext mc = this.top(MethodContext.class);
            mc._body();
        }

        void _if(Expression expr) {
            this.checkState(Operation.IF);
            new IfStatementContext(this.contexts, expr);
        }

        void _else() {
            this.checkState(Operation.ELSE);
            IfStatementContext isc = this.top(IfStatementContext.class);
            isc._else();
        }

        void _try() {
            this.checkState(Operation.TRY);
            new TryStatementContext(this.contexts);
        }

        Expression _catch(Type type, String name) {
            this.checkState(Operation.CATCH);
            TryStatementContext tsc = this.top(TryStatementContext.class);
            return tsc._catch(type, name);
        }

        void _finally() {
            this.checkState(Operation.FINALLY);
            TryStatementContext tsc = this.top(TryStatementContext.class);
            tsc._finally();
        }

        public void _switch(Expression expr) {
            this.checkState(Operation.SWITCH);
            new SwitchStatementContext(this.contexts, expr);
        }

        public void _case(int value) {
            this.checkState(Operation.CASE);
            SwitchStatementContext ssc = this.top(SwitchStatementContext.class);
            ssc._case(value);
        }

        public void _default() {
            this.checkState(Operation.DEFAULT);
            SwitchStatementContext ssc = this.top(SwitchStatementContext.class);
            ssc._default();
        }

        public void _while(Expression expr) {
            this.checkState(Operation.WHILE);
            new WhileStatementContext(this.contexts, expr);
        }

        public void _end() {
            this.checkState(Operation.END);
            this.contexts.peek()._end();
        }
    }

    private static class WhileStatementContext
    extends Context {
        private final WhileStatement whilestmt;

        WhileStatementContext(Stack<Context> contexts, Expression expr) {
            super(contexts, S_BODY);
            this.whilestmt = this.parent().bs().addWhile(expr);
            this.setBlockStatement(this.whilestmt.body());
        }
    }

    private static class TryStatementContext
    extends Context {
        private final TryStatement trystmt = this.parent().bs().addTry();
        private Variable currentCaseVariable = null;

        TryStatementContext(Stack<Context> contexts) {
            super(contexts, S_TRY);
            this.setBlockStatement(this.trystmt.bodyPart());
        }

        Expression _catch(Type type, String name) {
            Pair<Variable, BlockStatement> pair = this.trystmt.addCatch(type, name);
            this.setBlockStatement(pair.second());
            this.currentCaseVariable = pair.first();
            return this.currentCaseVariable;
        }

        void _finally() {
            this.setBlockStatement(this.trystmt.finalPart());
            this.currentCaseVariable = null;
        }

        @Override
        protected Expression alternateLookup(String ident) {
            if (this.currentCaseVariable != null && ident.equals(this.currentCaseVariable.ident())) {
                return this.currentCaseVariable;
            }
            return null;
        }

        @Override
        public void _end() {
            super._end();
            if (this.trystmt.catches().entrySet().isEmpty() && this.trystmt.finalPart().isEmpty()) {
                throw new IllegalStateException("A try statement must have at least one catch clause or a final part");
            }
        }
    }

    private static class SwitchStatementContext
    extends Context {
        private final SwitchStatement swstmt;

        SwitchStatementContext(Stack<Context> contexts, Expression expr) {
            super(contexts, S_SWITCH);
            this.swstmt = this.parent().bs().addSwitch(expr);
            this.setBlockStatement(null);
        }

        void _case(int value) {
            this.setBlockStatement(this.swstmt.addCase(value));
        }

        void _default() {
            this.setBlockStatement(this.swstmt.defaultCase());
        }
    }

    private static class IfStatementContext
    extends Context {
        private final IfStatement ifstmt;

        IfStatementContext(Stack<Context> contexts, Expression expr) {
            super(contexts, S_IF);
            this.ifstmt = this.parent().bs().addIf(expr);
            this.setBlockStatement(this.ifstmt.truePart());
        }

        void _else() {
            this.setBlockStatement(this.ifstmt.falsePart());
        }
    }

    private static class BodyContext
    extends Context {
        BodyContext(Stack<Context> contexts, BlockStatement bs) {
            super(contexts, S_BODY);
            this.setBlockStatement(bs);
        }
    }

    private static class MethodContext
    extends Context {
        private MethodGenerator mg;

        public MethodGenerator methodGenerator() {
            return this.mg;
        }

        MethodContext(Stack<Context> contexts, MethodGenerator mg) {
            super(contexts, S_METHOD);
            this.mg = mg;
            this.setBlockStatement(null);
        }

        Expression _arg(Type type, String ident) {
            return this.mg.addArgument(type, ident);
        }

        void _body() {
            this.setBlockStatement(this.mg.body());
        }

        @Override
        protected Expression alternateLookup(String ident) {
            for (Variable var : this.mg.arguments()) {
                if (!ident.equals(var.ident())) continue;
                return var;
            }
            return null;
        }

        @Override
        public void _end() {
            super._end();
            ClassGeneratorImpl cg = (ClassGeneratorImpl)this.mg.parent();
            cg.methodComplete(this.mg);
        }
    }

    private static class ClassContext
    extends Context {
        private final ClassGeneratorImpl cg;

        ClassContext(Stack<Context> contexts, ClassGeneratorImpl cg) {
            super(contexts, S_CLASS);
            this.cg = cg;
        }

        FieldGenerator _data(int modifiers, Type type, String name) {
            return this.cg.addField(modifiers, type, name);
        }

        void _method(int modifiers, Type type, String name, List<Type> exceptions) {
            MethodGenerator mg = this.cg.startMethod(modifiers, type, name, exceptions);
            new MethodContext((Stack<Context>)this.contexts, mg);
        }

        void _constructor(int modifiers, List<Type> exceptions) {
            MethodGenerator mg = this.cg.startConstructor(modifiers, exceptions);
            new MethodContext((Stack<Context>)this.contexts, mg);
        }

        @Override
        protected Expression alternateLookup(String ident) {
            FieldInfo fld = this.cg.findFieldInfo(ident);
            if (fld == null) {
                throw new IllegalArgumentException(ident + " not found in " + this.cg.name());
            }
            return ((FieldGenerator)fld).getExpression();
        }

        @Override
        public void _end() {
            super._end();
            ClassCopierOrdinaryImpl.setCodegenCopierAllowed(true);
        }
    }

    private static final class PackageContext
    extends Context {
        PackageContext(Stack<Context> contexts) {
            super(contexts, S_INIT);
            ClassCopierOrdinaryImpl.setCodegenCopierAllowed(false);
        }
    }

    private static abstract class Context {
        private final Runner runner;
        private final Context parent;
        final Stack<Context> contexts;
        private ExpressionFactory expressionFactory;
        private BlockStatement blockStatement;

        final ExpressionFactory ef() {
            if (this.expressionFactory == null) {
                throw new IllegalStateException("No ExpressionFactory is currently available");
            }
            return this.expressionFactory;
        }

        final BlockStatement bs() {
            if (this.blockStatement == null) {
                throw new IllegalStateException("No BlockStatement is currently available");
            }
            return this.blockStatement;
        }

        final void setBlockStatement(BlockStatement bs) {
            this.blockStatement = bs;
            this.expressionFactory = bs == null ? null : bs.exprFactory();
        }

        Context(Stack<Context> contexts, State start) {
            FSMImpl fsm = new FSMImpl(engine, start);
            this.runner = new Runner(fsm);
            this.contexts = contexts;
            this.parent = contexts.empty() ? null : contexts.peek();
            contexts.push(this);
            this.expressionFactory = null;
            this.blockStatement = null;
        }

        final void stateTransition(Operation op) {
            this.runner.doIt(op);
        }

        public final Context parent() {
            return this.parent;
        }

        protected Expression alternateLookup(String ident) {
            return null;
        }

        Expression getVariable(String ident) {
            Expression result = null;
            if (this.blockStatement != null) {
                result = this.blockStatement.getVar(ident);
            }
            if (result == null) {
                result = this.alternateLookup(ident);
            }
            if (result == null && this.parent != null) {
                result = this.parent.getVariable(ident);
            }
            if (result == null) {
                throw new IllegalArgumentException("Identifier " + ident + " not found.");
            }
            return result;
        }

        public void _end() {
            this.contexts.pop();
        }
    }
}

