/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.awt.geom.Point2D;
import java.util.Objects;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectPosition2D
extends Point2D.Double
implements DirectPosition,
Cloneable {
    private static final long serialVersionUID = 6063110617109934018L;
    private CoordinateReferenceSystem crs;

    public DirectPosition2D() {
    }

    public DirectPosition2D(CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureDimensionMatches("crs", 2, crs);
        this.crs = crs;
    }

    public DirectPosition2D(Point2D p) {
        super(p.getX(), p.getY());
    }

    public DirectPosition2D(double x, double y) {
        super(x, y);
    }

    public DirectPosition2D(CoordinateReferenceSystem crs, double x, double y) {
        super(x, y);
        this.crs = crs;
        ArgumentChecks.ensureDimensionMatches("crs", 2, crs);
    }

    public DirectPosition2D(DirectPosition position) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("position", position);
        ArgumentChecks.ensureDimensionMatches("position", 2, position);
        this.x = position.getOrdinate(0);
        this.y = position.getOrdinate(1);
        this.crs = position.getCoordinateReferenceSystem();
    }

    public DirectPosition2D(CharSequence wkt) throws IllegalArgumentException {
        double[] coordinates = AbstractDirectPosition.parse(wkt);
        if (coordinates == null) {
            throw new IllegalArgumentException(Errors.format((short)154, "POINT", wkt));
        }
        ArgumentChecks.ensureDimensionMatches("wkt", 2, coordinates);
        this.x = coordinates[0];
        this.y = coordinates[1];
    }

    public final DirectPosition getDirectPosition() {
        return this;
    }

    public final int getDimension() {
        return 2;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureDimensionMatches("crs", 2, crs);
        this.crs = crs;
    }

    public final double[] getCoordinate() {
        return new double[]{this.x, this.y};
    }

    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(Errors.format((short)71, dimension));
    }

    public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Errors.format((short)71, dimension));
            }
        }
    }

    @Override
    public void setLocation(Point2D position) {
        CoordinateReferenceSystem candidate;
        super.setLocation(position);
        if (position instanceof DirectPosition && (candidate = ((DirectPosition)position).getCoordinateReferenceSystem()) != null) {
            this.setCoordinateReferenceSystem(candidate);
        }
    }

    @Override
    public String toString() {
        return AbstractDirectPosition.toString(this, ArraysExt.isSinglePrecision(this.x, this.y));
    }

    @Override
    public int hashCode() {
        int code = 31 + Double.hashCode(this.x);
        code = code * 31 + Double.hashCode(this.y);
        return code + Objects.hashCode(this.crs);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DirectPosition) {
            DirectPosition other = (DirectPosition)object;
            if (other.getDimension() == 2 && Double.doubleToLongBits(other.getOrdinate(0)) == Double.doubleToLongBits(this.x) && Double.doubleToLongBits(other.getOrdinate(1)) == Double.doubleToLongBits(this.y) && Objects.equals(other.getCoordinateReferenceSystem(), this.crs)) {
                assert (this.hashCode() == other.hashCode()) : this;
                return true;
            }
            return false;
        }
        return super.equals(object);
    }

    @Override
    public DirectPosition2D clone() {
        return (DirectPosition2D)super.clone();
    }
}

