/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import javax.measure.Unit;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.WraparoundTransform;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class WraparoundApplicator {
    private final DirectPosition sourceMedian;
    private final DirectPosition targetMedian;
    private final CoordinateSystem targetCS;

    public WraparoundApplicator(DirectPosition sourceMedian, DirectPosition targetMedian, CoordinateSystem targetCS) {
        this.sourceMedian = sourceMedian;
        this.targetMedian = targetMedian;
        this.targetCS = targetCS;
    }

    public static MathTransform forTargetCRS(CoordinateOperation op) throws TransformException {
        WraparoundApplicator ap = new WraparoundApplicator(null, null, op.getTargetCRS().getCoordinateSystem());
        MathTransform tr = op.getMathTransform();
        for (int wraparoundDimension : CoordinateOperations.wrapAroundChanges(op)) {
            tr = ap.concatenate(tr, wraparoundDimension);
        }
        return tr;
    }

    public MathTransform forDomainOfUse(MathTransform tr) throws TransformException {
        int dimension = this.targetCS.getDimension();
        for (int i = 0; i < dimension; ++i) {
            tr = this.concatenate(tr, i);
        }
        return tr;
    }

    private MathTransform concatenate(MathTransform tr, int wraparoundDimension) throws TransformException {
        double sm;
        double m;
        double period = WraparoundApplicator.range(this.targetCS, wraparoundDimension);
        if (!(period > 0.0) || period == Double.POSITIVE_INFINITY) {
            return tr;
        }
        try {
            if (this.targetMedian == null) {
                CoordinateSystemAxis axis = this.targetCS.getAxis(wraparoundDimension);
                m = (axis.getMinimumValue() + axis.getMaximumValue()) / 2.0;
            } else {
                m = this.targetMedian.getOrdinate(wraparoundDimension);
            }
            if (!Double.isFinite(m)) {
                if (this.targetMedian != null) {
                    return tr;
                }
                m = 0.0;
            }
            sm = this.sourceMedian != null ? this.sourceMedian.getOrdinate(wraparoundDimension) : Double.NaN;
        }
        catch (BackingStoreException e) {
            throw e.unwrapOrRethrow(TransformException.class);
        }
        double max = Math.max(Math.abs(sm), Math.abs(m));
        if (Math.abs(sm - m) < max * 1.0E-13) {
            int n = Math.getExponent(max);
            if (WraparoundApplicator.error(sm, n) <= WraparoundApplicator.error(m, n)) {
                m = sm;
            } else {
                sm = m;
            }
        }
        MathTransform wraparound = WraparoundTransform.create(tr.getTargetDimensions(), wraparoundDimension, period, sm, m);
        return MathTransforms.concatenate(tr, wraparound);
    }

    private static double error(double m, int n) {
        m = Math.scalb(m, 6 - n);
        return Math.abs(m - Math.rint(m));
    }

    static double range(CoordinateSystem cs, int dimension) {
        CoordinateSystemAxis axis = cs.getAxis(dimension);
        if (axis != null && RangeMeaning.WRAPAROUND.equals(axis.getRangeMeaning())) {
            double period = axis.getMaximumValue() - axis.getMinimumValue();
            if (period > 0.0 && period != Double.POSITIVE_INFINITY) {
                return period;
            }
            AxisDirection dir = AxisDirections.absolute(axis.getDirection());
            if (AxisDirection.EAST.equals(dir) && cs instanceof EllipsoidalCS) {
                period = 360.0;
                Unit unit = axis.getUnit();
                if (unit != null) {
                    period = Units.DEGREE.getConverterTo(Units.ensureAngular(unit)).convert(period);
                }
                return period;
            }
        }
        return Double.NaN;
    }
}

