/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.StoredTree;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.UnparsableObjectException;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

class MathTransformParser
extends AbstractParser {
    static final String[] ID_KEYWORDS = new String[]{"Id", "Authority"};
    private static final String[] UNIT_KEYWORDS = new String[]{"Unit", "LengthUnit", "AngleUnit", "ScaleUnit", "TimeUnit", "ParametricUnit"};
    private static final Unit<?>[] BASE_UNITS = new Unit[]{Units.METRE, Units.RADIAN, Units.UNITY, Units.SECOND};
    private static final double[][] CONVERSION_FACTORS = new double[][]{{0.3048, 0.30480060960121924, 1609.3472186944375}, {4.84813681109536E-6, 2.908882086657216E-4, 0.015707963267948967, Math.PI / 180}};
    final ReferencingFactoryContainer factories;
    private transient String classification;
    private transient OperationMethod lastMethod;

    public MathTransformParser(MathTransformFactory mtFactory) {
        this(Symbols.getDefault(), Map.of(), null, null, null, new ReferencingFactoryContainer(null, null, null, null, null, mtFactory), null);
    }

    MathTransformParser(Symbols symbols, Map<String, StoredTree> fragments, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, ReferencingFactoryContainer factories, Locale errorLocale) {
        super(symbols, fragments, numberFormat, dateFormat, unitFormat, errorLocale);
        this.factories = factories;
        ArgumentChecks.ensureNonNull("factories", factories);
    }

    @Override
    String getPublicFacade() {
        return "org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory";
    }

    @Override
    Object buildFromTree(Element element) throws ParseException {
        return this.parseMathTransform(element, true);
    }

    final MathTransform parseMathTransform(Element element, boolean mandatory) throws ParseException {
        this.lastMethod = null;
        this.classification = null;
        MathTransform tr = this.parseParamMT(element);
        if (tr == null && (tr = this.parseConcatMT(element)) == null && (tr = this.parseInverseMT(element)) == null && (tr = this.parsePassThroughMT(element)) == null && mandatory) {
            throw element.missingOrUnknownComponent("Param_MT");
        }
        return tr;
    }

    final Unit<?> parseUnitID(Element parent) throws ParseException {
        Element element = parent.pullElement(1, ID_KEYWORDS);
        if (element != null) {
            String codeSpace = element.pullString("codeSpace");
            Object code = element.pullObject("code");
            element.close(this.ignoredElements);
            if ("EPSG".equalsIgnoreCase(codeSpace)) {
                try {
                    int n = Numbers.isInteger(code.getClass()) ? ((Number)code).intValue() : Integer.parseInt(code.toString());
                    return Units.valueOfEPSG(n);
                }
                catch (NumberFormatException e) {
                    this.warning(parent, element, null, (Exception)e);
                }
            }
        }
        return null;
    }

    final Unit<?> parseUnit(Element parent) throws ParseException {
        Element element = parent.pullElement(1, UNIT_KEYWORDS);
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        double factor = element.pullDouble("factor");
        int index = element.getKeywordIndex() - 1;
        Unit<?> unit = this.parseUnitID(element);
        element.close(this.ignoredElements);
        if (unit != null) {
            return unit;
        }
        if (index >= 0 && index < BASE_UNITS.length) {
            if (index < CONVERSION_FACTORS.length) {
                factor = MathTransformParser.completeUnitFactor(CONVERSION_FACTORS[index], factor);
            }
            return BASE_UNITS[index].multiply(factor);
        }
        try {
            return this.parseUnit(name);
        }
        catch (MeasurementParseException e) {
            throw new UnparsableObjectException(this.errorLocale, 150, new Object[]{name}, element.offset).initCause(e);
        }
    }

    private static double completeUnitFactor(double[] predefined, double factor) {
        int i = Arrays.binarySearch(predefined, factor);
        if (i < 0) {
            double next;
            i = Math.max(~i, 1);
            double accurate = predefined[i - 1];
            if (i < predefined.length && (next = predefined[i]) - factor < factor - accurate) {
                accurate = next;
            }
            if (DecimalFunctions.equalsIgnoreMissingFractionDigits(accurate, factor)) {
                return accurate;
            }
        }
        return factor;
    }

    static double completeUnitFactor(Unit<?> baseUnit, double factor) {
        int i = CONVERSION_FACTORS.length;
        while (--i >= 0) {
            if (BASE_UNITS[i] != baseUnit) continue;
            return MathTransformParser.completeUnitFactor(CONVERSION_FACTORS[i], factor);
        }
        return factor;
    }

    final void parseParameters(Element element, ParameterValueGroup parameters, Unit<?> defaultUnit, Unit<Angle> defaultAngularUnit) throws ParseException {
        Unit defaultSI = defaultUnit != null ? defaultUnit.getSystemUnit() : null;
        Element param = element;
        try {
            while ((param = element.pullElement(1, "Parameter")) != null) {
                String name = param.pullString("name");
                Object unit = this.parseUnit(param);
                param.pullElement(1, ID_KEYWORDS);
                ParameterValue parameter = parameters.parameter(name);
                ParameterDescriptor descriptor = parameter.getDescriptor();
                Class valueClass = descriptor.getValueClass();
                boolean isNumeric = Number.class.isAssignableFrom(valueClass);
                if (isNumeric && unit == null && (unit = descriptor.getUnit()) != null) {
                    Unit si = unit.getSystemUnit();
                    if (si.equals((Object)defaultSI)) {
                        unit = defaultUnit;
                    } else if (si.equals(Units.RADIAN)) {
                        unit = defaultAngularUnit;
                    }
                }
                if (unit != null) {
                    parameter.setValue(param.pullDouble("doubleValue"), (Unit)unit);
                } else if (isNumeric) {
                    if (Numbers.isInteger(valueClass)) {
                        parameter.setValue(param.pullInteger("intValue"));
                    } else {
                        parameter.setValue(param.pullDouble("doubleValue"));
                    }
                } else if (valueClass == Boolean.class) {
                    parameter.setValue(param.pullBoolean("booleanValue"));
                } else {
                    parameter.setValue((Object)param.pullString("stringValue"));
                }
                param.close(this.ignoredElements);
            }
        }
        catch (ParameterNotFoundException e) {
            throw new UnparsableObjectException(this.errorLocale, 140, new String[]{e.getParameterName()}, param.offset).initCause(e);
        }
        catch (InvalidParameterValueException e) {
            throw (ParseException)new ParseException(e.getLocalizedMessage(), param.offset).initCause(e);
        }
    }

    private MathTransform parseParamMT(Element parent) throws ParseException {
        MathTransform transform;
        ParameterValueGroup parameters;
        Element element = parent.pullElement(0, "Param_MT");
        if (element == null) {
            return null;
        }
        this.classification = element.pullString("classification");
        MathTransformFactory mtFactory = this.factories.getMathTransformFactory();
        try {
            parameters = mtFactory.getDefaultParameters(this.classification);
        }
        catch (NoSuchIdentifierException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
        this.parseParameters(element, parameters, null, null);
        element.close(this.ignoredElements);
        try {
            transform = mtFactory.createParameterizedTransform(parameters);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
        this.lastMethod = mtFactory.getLastMethodUsed();
        return transform;
    }

    private MathTransform parseInverseMT(Element parent) throws ParseException {
        Element element = parent.pullElement(0, "Inverse_MT");
        if (element == null) {
            return null;
        }
        MathTransform transform = this.parseMathTransform(element, true);
        try {
            transform = transform.inverse();
        }
        catch (NoninvertibleTransformException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
        element.close(this.ignoredElements);
        return transform;
    }

    private MathTransform parsePassThroughMT(Element parent) throws ParseException {
        Element element = parent.pullElement(0, "PassThrough_MT");
        if (element == null) {
            return null;
        }
        int firstAffectedCoordinate = parent.pullInteger("firstAffectedCoordinate");
        MathTransform transform = this.parseMathTransform(element, true);
        MathTransformFactory mtFactory = this.factories.getMathTransformFactory();
        element.close(this.ignoredElements);
        try {
            return mtFactory.createPassThroughTransform(firstAffectedCoordinate, transform, 0);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
    }

    private MathTransform parseConcatMT(Element parent) throws ParseException {
        MathTransform optionalTransform;
        Element element = parent.pullElement(0, "Concat_MT");
        if (element == null) {
            return null;
        }
        MathTransform transform = this.parseMathTransform(element, true);
        MathTransformFactory mtFactory = this.factories.getMathTransformFactory();
        while ((optionalTransform = this.parseMathTransform(element, false)) != null) {
            try {
                transform = mtFactory.createConcatenatedTransform(transform, optionalTransform);
            }
            catch (FactoryException exception) {
                throw element.parseFailed((Exception)((Object)exception));
            }
        }
        element.close(this.ignoredElements);
        return transform;
    }

    final OperationMethod getOperationMethod() {
        if (this.lastMethod == null && this.classification != null) {
            MathTransformFactory mtFactory = this.factories.getMathTransformFactory();
            this.lastMethod = CoordinateOperations.getOperationMethod(mtFactory.getAvailableMethods(SingleOperation.class), this.classification);
        }
        return this.lastMethod;
    }
}

