/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.ParameterFormat;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;

@XmlType(name="AbstractGeneralOperationParameterType", propOrder={"nonDefaultMinimumOccurs", "nonDefaultMaximumOccurs"})
@XmlSeeAlso(value={DefaultParameterDescriptor.class, DefaultParameterDescriptorGroup.class})
public abstract class AbstractParameterDescriptor
extends AbstractIdentifiedObject
implements GeneralParameterDescriptor {
    private static final long serialVersionUID = -4346475760810353590L;
    private short minimumOccurs;
    private short maximumOccurs;

    protected AbstractParameterDescriptor(Map<String, ?> properties, int minimumOccurs, int maximumOccurs) {
        super(properties);
        this.minimumOccurs = (short)minimumOccurs;
        this.maximumOccurs = (short)maximumOccurs;
        if (minimumOccurs < 0 || minimumOccurs > maximumOccurs || maximumOccurs == 0) {
            throw new IllegalArgumentException(Errors.getResources(properties).getString((short)60, minimumOccurs, maximumOccurs));
        }
        if (maximumOccurs > 65534 && maximumOccurs != Integer.MAX_VALUE) {
            throw new IllegalArgumentException(Errors.getResources(properties).getString((short)130, 65534, super.getName().getCode()));
        }
    }

    protected AbstractParameterDescriptor(GeneralParameterDescriptor descriptor) {
        super((IdentifiedObject)descriptor);
        this.minimumOccurs = AbstractParameterDescriptor.crop(descriptor.getMinimumOccurs());
        this.maximumOccurs = AbstractParameterDescriptor.crop(descriptor.getMaximumOccurs());
    }

    private static short crop(int n) {
        return (short)Math.max(0, Math.min(65535, n));
    }

    public Class<? extends GeneralParameterDescriptor> getInterface() {
        return GeneralParameterDescriptor.class;
    }

    public int getMinimumOccurs() {
        return Short.toUnsignedInt(this.minimumOccurs);
    }

    public int getMaximumOccurs() {
        return this.maximumOccurs != -1 ? Short.toUnsignedInt(this.maximumOccurs) : Integer.MAX_VALUE;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            switch (mode) {
                case STRICT: {
                    AbstractParameterDescriptor that = (AbstractParameterDescriptor)object;
                    return this.minimumOccurs == that.minimumOccurs && this.maximumOccurs == that.maximumOccurs;
                }
            }
            GeneralParameterDescriptor that = (GeneralParameterDescriptor)object;
            return this.getMinimumOccurs() == that.getMinimumOccurs() && this.getMaximumOccurs() == that.getMaximumOccurs() && Objects.equals(this.getDirection(), that.getDirection()) && Utilities.deepEquals(this.getDescription(), that.getDescription(), mode);
        }
        return false;
    }

    @Override
    public String toString() {
        if (this instanceof ParameterDescriptorGroup) {
            return ParameterFormat.sharedFormat(this);
        }
        return super.toString();
    }

    @Override
    public void print() {
        if (this instanceof ParameterDescriptorGroup) {
            ParameterFormat.print(this);
        } else {
            super.print();
        }
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        formatter.setInvalidWKT(this, null);
        if (this instanceof ParameterDescriptorGroup) {
            for (AbstractParameterDescriptor parameter : ((ParameterDescriptorGroup)this).descriptors()) {
                if (!(parameter instanceof FormattableObject)) {
                    if (parameter instanceof ParameterDescriptor) {
                        parameter = new DefaultParameterDescriptor(parameter);
                    } else {
                        if (!(parameter instanceof ParameterDescriptorGroup)) continue;
                        parameter = new DefaultParameterDescriptorGroup((ParameterDescriptorGroup)parameter);
                    }
                }
                formatter.newLine();
                formatter.append(parameter);
            }
            return "ParameterGroup";
        }
        if (this instanceof ParameterDescriptor) {
            Object defaultValue = ((ParameterDescriptor)this).getDefaultValue();
            if (defaultValue != null) {
                formatter.appendAny(defaultValue);
            }
            formatter.append(((ParameterDescriptor)this).getUnit());
        }
        return "Parameter";
    }

    AbstractParameterDescriptor() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
        this.minimumOccurs = 1;
        this.maximumOccurs = 1;
    }

    @XmlElement(name="minimumOccurs")
    @XmlSchemaType(name="nonNegativeInteger")
    private Integer getNonDefaultMinimumOccurs() {
        int n = this.getMinimumOccurs();
        return n != 1 ? Integer.valueOf(n) : null;
    }

    @XmlElement(name="maximumOccurs")
    @XmlSchemaType(name="nonNegativeInteger")
    private Integer getNonDefaultMaximumOccurs() {
        int n = this.getMaximumOccurs();
        return n != 1 ? Integer.valueOf(n) : null;
    }

    private void setNonDefaultMinimumOccurs(Integer n) {
        this.minimumOccurs = n != null ? AbstractParameterDescriptor.crop(n) : (short)1;
    }

    private void setNonDefaultMaximumOccurs(Integer n) {
        this.maximumOccurs = n != null ? AbstractParameterDescriptor.crop(n) : (short)1;
    }
}

