/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.AbstractReferenceSystem;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.crs.AbstractDerivedCRS;
import org.apache.sis.referencing.crs.DefaultCompoundCRS;
import org.apache.sis.referencing.crs.DefaultEngineeringCRS;
import org.apache.sis.referencing.crs.DefaultGeodeticCRS;
import org.apache.sis.referencing.crs.DefaultImageCRS;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.crs.SubTypes;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;

@XmlType(name="AbstractCRSType", propOrder={"domainOfValidity", "scope"})
@XmlRootElement(name="AbstractCRS")
@XmlSeeAlso(value={AbstractDerivedCRS.class, DefaultGeodeticCRS.class, DefaultVerticalCRS.class, DefaultTemporalCRS.class, DefaultParametricCRS.class, DefaultEngineeringCRS.class, DefaultImageCRS.class, DefaultCompoundCRS.class})
public class AbstractCRS
extends AbstractReferenceSystem
implements CoordinateReferenceSystem {
    private static final long serialVersionUID = -7433284548909530047L;
    private CoordinateSystem coordinateSystem;
    private transient Map<AxesConvention, AbstractCRS> forConvention;

    public AbstractCRS(Map<String, ?> properties, CoordinateSystem cs) {
        super(properties);
        ArgumentChecks.ensureNonNull("cs", cs);
        this.coordinateSystem = cs;
    }

    protected AbstractCRS(CoordinateReferenceSystem crs) {
        super((ReferenceSystem)crs);
        this.coordinateSystem = crs.getCoordinateSystem();
    }

    public static AbstractCRS castOrCopy(CoordinateReferenceSystem object) {
        return SubTypes.castOrCopy(object);
    }

    public Class<? extends CoordinateReferenceSystem> getInterface() {
        return CoordinateReferenceSystem.class;
    }

    Datum getDatum() {
        return this instanceof SingleCRS ? ((SingleCRS)this).getDatum() : null;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    final <T extends CoordinateSystem> T getCoordinateSystem(Class<T> type) {
        CoordinateSystem cs = this.coordinateSystem;
        if (type.isInstance(cs) && (type != AffineCS.class || !(cs instanceof CartesianCS))) {
            return (T)cs;
        }
        return null;
    }

    final AbstractCRS getCached(AxesConvention convention) {
        assert (Thread.holdsLock(this));
        return this.forConvention != null ? this.forConvention.get(convention) : null;
    }

    final AbstractCRS setCached(AxesConvention convention, AbstractCRS crs) {
        assert (Thread.holdsLock(this));
        if (this.forConvention == null) {
            this.forConvention = new EnumMap<AxesConvention, AbstractCRS>(AxesConvention.class);
        } else if (crs != this) {
            for (AbstractCRS existing : this.forConvention.values()) {
                if (!crs.equals(existing)) continue;
                crs = existing;
                break;
            }
        }
        if (this.forConvention.put(convention, crs) != null) {
            throw new ConcurrentModificationException();
        }
        return crs;
    }

    public synchronized AbstractCRS forConvention(AxesConvention convention) {
        ArgumentChecks.ensureNonNull("convention", convention);
        AbstractCRS crs = this.getCached(convention);
        if (crs == null) {
            AbstractCS cs = AbstractCS.castOrCopy(this.coordinateSystem);
            AbstractCS candidate = cs.forConvention(convention);
            if (candidate == cs) {
                crs = this;
            } else {
                Map<String, ?> properties = IdentifiedObjects.getProperties(this, "identifiers");
                Identifier name = this.getName();
                if (name.getCodeSpace() != null || name.getAuthority() != null) {
                    name = new NamedIdentifier(null, name.getCode());
                    HashMap copy = new HashMap(properties);
                    copy.put("name", name);
                    properties = copy;
                }
                crs = this.createSameType(properties, candidate);
            }
            crs = this.setCached(convention, crs);
        }
        return crs;
    }

    AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        return new AbstractCRS(properties, cs);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            Datum datum = this.getDatum();
            switch (mode) {
                case STRICT: {
                    AbstractCRS that = (AbstractCRS)object;
                    return Objects.equals(datum, that.getDatum()) && Objects.equals(this.coordinateSystem, that.coordinateSystem);
                }
            }
            return Utilities.deepEquals(datum, object instanceof SingleCRS ? ((SingleCRS)object).getDatum() : null, mode) && Utilities.deepEquals(this.getCoordinateSystem(), ((CoordinateReferenceSystem)object).getCoordinateSystem(), mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.getDatum(), this.coordinateSystem);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean isWKT1;
        String keyword = super.formatTo(formatter);
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable(this.getDatum()));
        formatter.newLine();
        Convention convention = formatter.getConvention();
        boolean bl = isWKT1 = convention.majorVersion() == 1;
        if (isWKT1 || convention == Convention.INTERNAL || !AbstractCRS.isBaseCRS(formatter)) {
            CoordinateSystem cs = this.getCoordinateSystem();
            this.formatCS(formatter, cs, ReferencingUtilities.getUnit(cs), isWKT1);
        }
        return keyword;
    }

    static boolean isBaseCRS(Formatter formatter) {
        return formatter.getEnclosingElement(1) instanceof GeneralDerivedCRS;
    }

    final void formatCS(Formatter formatter, CoordinateSystem cs, Unit<?> unit, boolean isWKT1) {
        assert (unit == ReferencingUtilities.getUnit(cs)) : unit;
        assert (formatter.getConvention().majorVersion() == 1 == isWKT1) : isWKT1;
        assert (isWKT1 || !AbstractCRS.isBaseCRS(formatter) || formatter.getConvention() == Convention.INTERNAL);
        Unit<?> oldUnit = formatter.addContextualUnit(unit);
        if (isWKT1) {
            formatter.append(unit);
            if (unit == null) {
                formatter.setInvalidWKT(this, null);
            }
        } else {
            formatter.append(WKTUtilities.toFormattable(cs));
            formatter.indent(1);
        }
        if (!(isWKT1 && formatter.getConvention() == Convention.WKT1_IGNORE_AXES || cs == null)) {
            int dimension = cs.getDimension();
            for (int i = 0; i < dimension; ++i) {
                formatter.newLine();
                formatter.append(WKTUtilities.toFormattable(cs.getAxis(i)));
            }
        }
        if (!isWKT1) {
            formatter.newLine();
            formatter.append(unit);
            formatter.indent(-1);
        }
        formatter.restoreContextualUnit(unit, oldUnit);
        formatter.newLine();
    }

    AbstractCRS() {
        super(NilReferencingObject.INSTANCE);
    }

    final void setCoordinateSystem(String name, CoordinateSystem cs) {
        if (this.coordinateSystem == null) {
            this.coordinateSystem = cs;
        } else {
            if (name == null) {
                name = String.valueOf(ReferencingUtilities.toPropertyName(CoordinateSystem.class, cs.getClass()));
            }
            ImplementationHelper.propertyAlreadySet(AbstractCRS.class, "setCoordinateSystem", name);
        }
    }
}

