/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.util.ControlledVocabulary;

@XmlType(name="CoordinateSystemAxisType", propOrder={"abbreviation", "direction", "minimum", "maximum", "rangeMeaning"})
@XmlRootElement(name="CoordinateSystemAxis")
public class DefaultCoordinateSystemAxis
extends AbstractIdentifiedObject
implements CoordinateSystemAxis {
    private static final long serialVersionUID = -7883614853277827689L;
    public static final String MINIMUM_VALUE_KEY = "minimumValue";
    public static final String MAXIMUM_VALUE_KEY = "maximumValue";
    public static final String RANGE_MEANING_KEY = "rangeMeaning";
    private static final Map<String, Object> ALIASES = Map.of("lat", Boolean.TRUE, "latitude", Boolean.TRUE, "geodetic latitude", Boolean.TRUE, "lon", Boolean.FALSE, "long", Boolean.FALSE, "longitude", Boolean.FALSE, "geodetic longitude", Boolean.FALSE);
    private static final String[] ALIASES_XY = new String[]{"Easting", "Northing", "Westing", "Southing"};
    private String abbreviation;
    private AxisDirection direction;
    private Unit<?> unit;
    private double minimumValue;
    private double maximumValue;
    private RangeMeaning rangeMeaning;

    private static Object getAliasType(String name) {
        return ALIASES.get(name.strip().toLowerCase(Locale.US));
    }

    public DefaultCoordinateSystemAxis(Map<String, ?> properties, String abbreviation, AxisDirection direction, Unit<?> unit) {
        super(properties);
        this.abbreviation = abbreviation;
        this.direction = direction;
        this.unit = unit;
        ArgumentChecks.ensureNonEmpty("abbreviation", abbreviation);
        ArgumentChecks.ensureNonNull("direction", direction);
        ArgumentChecks.ensureNonNull("unit", unit);
        Number minimum = Containers.property(properties, MINIMUM_VALUE_KEY, Number.class);
        Number maximum = Containers.property(properties, MAXIMUM_VALUE_KEY, Number.class);
        RangeMeaning rm = Containers.property(properties, RANGE_MEANING_KEY, RangeMeaning.class);
        if (minimum == null && maximum == null && rm == null) {
            double min = Double.NEGATIVE_INFINITY;
            double max = Double.POSITIVE_INFINITY;
            if (Units.isAngular(unit)) {
                UnitConverter fromDegrees = Units.DEGREE.getConverterTo(unit.asType(Angle.class));
                AxisDirection dir = AxisDirections.absolute(direction);
                if (dir.equals(AxisDirection.NORTH)) {
                    min = fromDegrees.convert(-90.0);
                    max = fromDegrees.convert(90.0);
                    rm = RangeMeaning.EXACT;
                } else if (dir.equals(AxisDirection.EAST)) {
                    min = fromDegrees.convert(-180.0);
                    max = fromDegrees.convert(180.0);
                    rm = RangeMeaning.WRAPAROUND;
                }
                if (min > max) {
                    double t = min;
                    min = max;
                    max = t;
                }
            }
            this.minimumValue = min;
            this.maximumValue = max;
        } else {
            this.minimumValue = minimum != null ? minimum.doubleValue() : Double.NEGATIVE_INFINITY;
            double d = this.maximumValue = maximum != null ? maximum.doubleValue() : Double.POSITIVE_INFINITY;
            if (!(this.minimumValue < this.maximumValue)) {
                throw new IllegalArgumentException(Errors.getResources(properties).getString((short)60, this.minimumValue, this.maximumValue));
            }
            if (this.minimumValue != Double.NEGATIVE_INFINITY || this.maximumValue != Double.POSITIVE_INFINITY) {
                ArgumentChecks.ensureNonNull(RANGE_MEANING_KEY, rm);
            } else {
                rm = null;
            }
        }
        this.rangeMeaning = rm;
    }

    protected DefaultCoordinateSystemAxis(CoordinateSystemAxis axis) {
        super((IdentifiedObject)axis);
        this.abbreviation = axis.getAbbreviation();
        this.direction = axis.getDirection();
        this.unit = axis.getUnit();
        this.minimumValue = axis.getMinimumValue();
        this.maximumValue = axis.getMaximumValue();
        this.rangeMeaning = axis.getRangeMeaning();
    }

    public static DefaultCoordinateSystemAxis castOrCopy(CoordinateSystemAxis object) {
        return object == null || object instanceof DefaultCoordinateSystemAxis ? (DefaultCoordinateSystemAxis)object : new DefaultCoordinateSystemAxis(object);
    }

    public Class<? extends CoordinateSystemAxis> getInterface() {
        return CoordinateSystemAxis.class;
    }

    @XmlElement(name="axisDirection", required=true)
    public AxisDirection getDirection() {
        return this.direction;
    }

    @XmlElement(name="axisAbbrev", required=true)
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @XmlAttribute(name="uom", required=true)
    public Unit<?> getUnit() {
        return this.unit;
    }

    public double getMinimumValue() {
        return this.minimumValue;
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    private static void outOfRange(String name, Double value) {
        Context.warningOccured(Context.current(), DefaultCoordinateSystemAxis.class, name, Errors.class, (short)67, name, value);
    }

    @XmlElement(name="rangeMeaning")
    public RangeMeaning getRangeMeaning() {
        return this.rangeMeaning;
    }

    @Override
    public boolean isHeuristicMatchForName(String name) {
        if (super.isHeuristicMatchForName(name)) {
            return true;
        }
        Object type = DefaultCoordinateSystemAxis.getAliasType(name);
        return type != null && type == DefaultCoordinateSystemAxis.getAliasType(this.getName().getCode());
    }

    private static boolean isHeuristicMatchForNameXY(String xy, String name) {
        int i;
        if ((xy = xy.strip()).length() == 1 && (i = Character.toLowerCase(xy.charAt(0)) - 120) >= 0 && i <= 1 && !(name = name.strip()).isEmpty()) {
            do {
                if (!name.regionMatches(true, 0, ALIASES_XY[i], 0, name.length())) continue;
                return true;
            } while ((i += 2) < ALIASES_XY.length);
        }
        return false;
    }

    private boolean equalsIgnoreMetadata(CoordinateSystemAxis that, ComparisonMode mode, boolean cr) {
        return Objects.equals(this.getDirection(), that.getDirection()) && Utilities.deepEquals(this.getUnit(), that.getUnit(), mode) && (!cr || Double.doubleToLongBits(this.getMinimumValue()) == Double.doubleToLongBits(that.getMinimumValue()) && Double.doubleToLongBits(this.getMaximumValue()) == Double.doubleToLongBits(that.getMaximumValue()));
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        String thisCode;
        String thatCode;
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                DefaultCoordinateSystemAxis that = (DefaultCoordinateSystemAxis)object;
                return Objects.equals(this.unit, that.unit) && Objects.equals(this.direction, that.direction) && Objects.equals(this.abbreviation, that.abbreviation) && Objects.equals(this.rangeMeaning, that.rangeMeaning) && Double.doubleToLongBits(this.minimumValue) == Double.doubleToLongBits(that.minimumValue) && Double.doubleToLongBits(this.maximumValue) == Double.doubleToLongBits(that.maximumValue);
            }
            case BY_CONTRACT: {
                CoordinateSystemAxis that = (CoordinateSystemAxis)object;
                return this.equalsIgnoreMetadata(that, mode, true) && Objects.equals(this.getAbbreviation(), that.getAbbreviation()) && Objects.equals(this.getRangeMeaning(), that.getRangeMeaning());
            }
        }
        CoordinateSystemAxis that = (CoordinateSystemAxis)object;
        if (!this.equalsIgnoreMetadata(that, mode, RangeMeaning.WRAPAROUND.equals(this.getRangeMeaning()) && RangeMeaning.WRAPAROUND.equals(that.getRangeMeaning()))) {
            return false;
        }
        Identifier name = that.getName();
        return name == NilReferencingObject.UNNAMED || this.isHeuristicMatchForName(thatCode = name.getCode()) || (name = this.getName()) == NilReferencingObject.UNNAMED || IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)that, thisCode = name.getCode()) || DefaultCoordinateSystemAxis.isHeuristicMatchForNameXY(thatCode, thisCode) || DefaultCoordinateSystemAxis.isHeuristicMatchForNameXY(thisCode, thatCode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.unit) + (long)Objects.hashCode(this.direction) + Double.doubleToLongBits(this.minimumValue) + 31L * Double.doubleToLongBits(this.maximumValue);
    }

    private static CoordinateSystem getEnclosingCS(Formatter formatter) {
        FormattableObject e = formatter.getEnclosingElement(1);
        if (e instanceof CoordinateReferenceSystem) {
            return ((CoordinateReferenceSystem)e).getCoordinateSystem();
        }
        if (e instanceof CoordinateSystem) {
            return (CoordinateSystem)e;
        }
        return null;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        String a;
        Convention convention = formatter.getConvention();
        boolean isWKT1 = convention.majorVersion() == 1;
        boolean isInternal = convention == Convention.INTERNAL;
        CoordinateSystem cs = DefaultCoordinateSystemAxis.getEnclosingCS(formatter);
        AxisDirection dir = this.getDirection();
        String name = IdentifiedObjects.getName(this, formatter.getNameAuthority());
        if (name == null) {
            name = IdentifiedObjects.getName(this, null);
        }
        if (name != null && !isInternal) {
            String old = name;
            name = formatter.getTransliterator().toShortAxisName(cs, dir, name);
            if (name == null && isWKT1) {
                name = old;
            }
        }
        if (!isWKT1 && (a = formatter.getTransliterator().toLatinAbbreviation(cs, dir, this.getAbbreviation())) != null && !a.equals(name)) {
            StringBuilder buffer = new StringBuilder();
            if (name != null) {
                buffer.append(name).append(' ');
            }
            name = buffer.append('(').append(a).append(')').toString();
        }
        formatter.append(name, ElementKind.AXIS);
        DirectionAlongMeridian meridian = null;
        if (AxisDirections.isUserDefined(dir) && (meridian = DirectionAlongMeridian.parse(dir)) != null) {
            dir = meridian.baseDirection;
            if (isWKT1) {
                formatter.setInvalidWKT(this, null);
            }
        }
        formatter.append((ControlledVocabulary)dir);
        formatter.append(meridian);
        if (!isWKT1) {
            if (convention == Convention.WKT2 && cs != null) {
                Order order = Order.create(cs, this);
                if (order != null) {
                    formatter.append(order);
                } else {
                    formatter.setInvalidWKT((IdentifiedObject)cs, null);
                }
            }
            if (!formatter.hasContextualUnit(1)) {
                formatter.append(this.getUnit());
            }
        }
        return "Axis";
    }

    private DefaultCoordinateSystemAxis() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
        this.minimumValue = Double.NEGATIVE_INFINITY;
        this.maximumValue = Double.POSITIVE_INFINITY;
    }

    private void setAbbreviation(String value) {
        if (this.abbreviation == null) {
            this.abbreviation = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultCoordinateSystemAxis.class, "setAbbreviation", "abbreviation");
        }
    }

    private void setDirection(AxisDirection value) {
        if (this.direction == null) {
            this.direction = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultCoordinateSystemAxis.class, "setDirection", "direction");
        }
    }

    private void setUnit(Unit<?> value) {
        if (this.unit == null) {
            this.unit = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultCoordinateSystemAxis.class, "setUnit", "unit");
        }
    }

    private void setRangeMeaning(RangeMeaning value) {
        if (this.rangeMeaning == null) {
            this.rangeMeaning = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultCoordinateSystemAxis.class, "setRangeMeaning", RANGE_MEANING_KEY);
        }
    }

    @XmlElement(name="minimumValue")
    private Double getMinimum() {
        return this.minimumValue != Double.NEGATIVE_INFINITY ? Double.valueOf(this.minimumValue) : null;
    }

    private void setMinimum(Double value) {
        if (this.minimumValue == Double.NEGATIVE_INFINITY) {
            double min = value;
            if (min < this.maximumValue) {
                this.minimumValue = min;
            } else {
                DefaultCoordinateSystemAxis.outOfRange(MINIMUM_VALUE_KEY, value);
            }
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultCoordinateSystemAxis.class, "setMinimum", MINIMUM_VALUE_KEY);
        }
    }

    @XmlElement(name="maximumValue")
    private Double getMaximum() {
        return this.maximumValue != Double.POSITIVE_INFINITY ? Double.valueOf(this.maximumValue) : null;
    }

    private void setMaximum(Double value) {
        if (this.maximumValue == Double.POSITIVE_INFINITY) {
            double max = value;
            if (max > this.minimumValue) {
                this.maximumValue = max;
            } else {
                DefaultCoordinateSystemAxis.outOfRange(MAXIMUM_VALUE_KEY, value);
            }
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultCoordinateSystemAxis.class, "setMaximum", MAXIMUM_VALUE_KEY);
        }
    }

    private static final class Order
    extends FormattableObject {
        private final int index;

        static Order create(CoordinateSystem cs, DefaultCoordinateSystemAxis axis) {
            Order order = null;
            int dimension = cs.getDimension();
            int i = 0;
            while (i < dimension) {
                if (cs.getAxis(i++) != axis) continue;
                if (order == null) {
                    order = new Order(i);
                    continue;
                }
                return null;
            }
            return order;
        }

        private Order(int index) {
            this.index = index;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            formatter.append(this.index);
            return "Order";
        }
    }
}

