/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.ExtentSelector;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.factory.FactoryDataException;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.util.FactoryException;

final class BursaWolfInfo {
    static final int TARGET_CRS = 4326;
    static final int TARGET_DATUM = 6326;
    static final int MIN_METHOD_CODE = 9603;
    static final int MAX_METHOD_CODE = 9607;
    private static final int ROTATION_FRAME_CODE = 9607;
    final int operation;
    final int method;
    final int target;
    private final int domainOfValidity;
    private Extent extent;

    static void setBursaWolfParameter(BursaWolfParameters parameters, int code, double value, Unit<?> unit, Locale locale) throws FactoryDataException {
        Object target = unit;
        if (code >= 8605) {
            if (code <= 8607) {
                target = Units.METRE;
            } else if (code <= 8610) {
                target = Units.ARC_SECOND;
            } else if (code == 8611) {
                target = Units.PPM;
            }
        }
        if (target != unit) {
            try {
                value = unit.getConverterToAny(target).convert(value);
            }
            catch (IncommensurableException e) {
                throw new FactoryDataException(Errors.getResources(locale).getString((short)65, unit), e);
            }
        }
        switch (code) {
            case 8605: {
                parameters.tX = value;
                break;
            }
            case 8606: {
                parameters.tY = value;
                break;
            }
            case 8607: {
                parameters.tZ = value;
                break;
            }
            case 8608: {
                parameters.rX = value;
                break;
            }
            case 8609: {
                parameters.rY = value;
                break;
            }
            case 8610: {
                parameters.rZ = value;
                break;
            }
            case 8611: {
                parameters.dS = value;
                break;
            }
            default: {
                throw new FactoryDataException(Errors.getResources(locale).getString((short)140, code));
            }
        }
    }

    BursaWolfInfo(int operation, int method, int targetCRS, int domainOfValidity) {
        this.operation = operation;
        this.method = method;
        this.domainOfValidity = domainOfValidity;
        switch (targetCRS) {
            case 4326: {
                this.target = 6326;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(targetCRS));
            }
        }
    }

    boolean isFrameRotation() {
        return this.method == 9607;
    }

    public String toString() {
        return String.valueOf(this.operation);
    }

    Extent getDomainOfValidity(GeodeticAuthorityFactory factory) throws FactoryException {
        if (this.extent == null && this.domainOfValidity != 0) {
            this.extent = factory.createExtent(String.valueOf(this.domainOfValidity));
        }
        return this.extent;
    }

    static void filter(GeodeticAuthorityFactory factory, BursaWolfInfo[] candidates, List<BursaWolfInfo> addTo) throws FactoryException {
        LinkedHashMap<Integer, ExtentSelector<BursaWolfInfo>> added = new LinkedHashMap<Integer, ExtentSelector<BursaWolfInfo>>();
        for (BursaWolfInfo candidate : candidates) {
            Integer target = candidate.target;
            ExtentSelector<BursaWolfInfo> selector = (ExtentSelector<BursaWolfInfo>)added.get(target);
            if (selector == null) {
                selector = new ExtentSelector<BursaWolfInfo>(null);
                added.put(target, selector);
            }
            selector.evaluate(candidate.getDomainOfValidity(factory), candidate);
        }
        for (ExtentSelector select : added.values()) {
            addTo.add((BursaWolfInfo)select.best());
        }
    }
}

