/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter.temporal;

import jakarta.ws.rs.core.Response;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.cite.geomatics.time.TemporalUtils;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.temporal.AbstractTemporalTest;
import org.opengis.cite.iso19142.basic.filter.temporal.TemporalQuery;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TimeUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.temporal.Period;
import org.opengis.temporal.RelativePosition;
import org.opengis.temporal.TemporalGeometricPrimitive;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeforeTests
extends AbstractTemporalTest {
    private static final String BEFORE_OP = "Before";

    @BeforeClass
    public void implementsBeforeOperator() {
        if (!ServiceMetadataUtils.implementsTemporalOperator(this.wfsMetadata, BEFORE_OP)) {
            throw new SkipException(ErrorMessage.format("CapabilityNotImplemented", "Before operator"));
        }
    }

    @Test(description="See ISO 19143: A.10", dataProvider="protocol-featureType")
    public void beforePeriod(ProtocolBinding binding, QName featureType) {
        AbstractTemporalTest.TemporalProperty temporalProperty = this.findTemporalProperty(featureType);
        List subIntervals = TemporalUtils.splitInterval((Period)temporalProperty.getExtent(), (int)3);
        Period lastSubInterval = (Period)subIntervals.get(2);
        Document gmlTimeLiteral = TimeUtils.periodAsGMLAddOneDay(lastSubInterval);
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        Element valueRef = WFSMessage.createValueReference(temporalProperty.getProperty());
        WFSMessage.addTemporalPredicate(this.reqEntity, BEFORE_OP, gmlTimeLiteral, valueRef);
        Response rsp = this.wfsClient.getFeature(new DOMSource(this.reqEntity), binding);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        List<Node> temporalNodes = TemporalQuery.extractTemporalNodes(this.rspEntity, temporalProperty.getProperty(), this.getModel());
        this.assertBefore(temporalNodes, temporalProperty.getProperty(), gmlTimeLiteral);
    }

    void assertBefore(List<Node> temporalNodes, XSElementDeclaration propertyDecl, Document gmlTimeLiteral) {
        Assert.assertFalse((boolean)temporalNodes.isEmpty(), (String)String.format("No temporal values found in results: property is %s.", propertyDecl));
        TemporalGeometricPrimitive t2 = GmlUtils.gmlToTemporalGeometricPrimitive((Element)gmlTimeLiteral.getDocumentElement());
        XSTypeDefinition typeDef = propertyDecl.getTypeDefinition();
        for (Node timeNode : temporalNodes) {
            TemporalGeometricPrimitive t1 = null;
            t1 = typeDef.getTypeCategory() == 16 || ((XSComplexTypeDefinition)typeDef).getContentType() == 1 ? TemporalQuery.parseTemporalValue(timeNode.getTextContent(), typeDef) : GmlUtils.gmlToTemporalGeometricPrimitive((Element)((Element)timeNode));
            TemporalUtils.assertTemporalRelation((RelativePosition)RelativePosition.BEFORE, (TemporalGeometricPrimitive)t1, (TemporalGeometricPrimitive)t2);
        }
    }
}

