/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.transaction;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.WFS2;
import org.opengis.cite.iso19142.basic.filter.ResourceId;
import org.opengis.cite.iso19142.transaction.TransactionFixture;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InsertTests
extends TransactionFixture {
    private Map<String, QName> createdFeatures = new HashMap<String, QName>();

    @AfterClass
    public void deleteInsertedFeatures() {
        Boolean result;
        if (this.createdFeatures.isEmpty()) {
            return;
        }
        Document rspEntity = this.wfsClient.deleteFeatures(this.createdFeatures, ProtocolBinding.ANY);
        String xpath = String.format("//wfs:totalDeleted = '%d'", this.createdFeatures.size());
        try {
            result = (Boolean)XMLUtils.evaluateXPath(rspEntity, xpath, null, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (!result.booleanValue()) {
            String msg = String.format("%s: Failed to remove all new features:\n %s \n%s", this.getClass().getName(), this.createdFeatures, XMLUtils.writeNodeToString(rspEntity));
            TestSuiteLogger.log(Level.WARNING, msg);
        }
        this.createdFeatures.clear();
    }

    @Test(description="See ISO 19142: 15.2.4, 15.3.4", dataProvider="binding+availFeatureType")
    public void insertSupportedFeature(ProtocolBinding binding, QName featureType) {
        Node feature = this.createFeatureInstance(featureType);
        WFSMessage.addInsertStatement(this.reqEntity, feature);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "Transaction", binding);
        Response rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = (Document)rsp.readEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        ETSAssert.assertXPath("//wfs:TransactionResponse/wfs:InsertResults", this.rspEntity, null);
        List<ResourceId> newFeatureIDs = InsertTests.extractFeatureIdentifiers(this.rspEntity, WFS2.Transaction.INSERT);
        String rid = newFeatureIDs.get(0).getRid();
        this.createdFeatures.put(rid, featureType);
        ETSAssert.assertFeatureAvailability(rid, true, this.wfsClient);
    }

    @Test(description="See ISO 19142: 7.5, 15.4")
    public void insertInvalidFeature() {
        try {
            this.reqEntity = this.docBuilder.parse(this.getClass().getResourceAsStream("InsertUnrecognizedFeature.xml"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse InsertUnrecognizedFeature.xml from classpath", e);
        }
        ProtocolBinding binding = this.wfsClient.getAnyTransactionBinding();
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "Transaction", binding);
        Response rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = (Document)rsp.readEntity(Document.class);
        String xpath = "//ows:Exception[@exceptionCode = 'InvalidValue']";
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }

    public static List<ResourceId> extractFeatureIdentifiers(Document entity, WFS2.Transaction action) {
        ArrayList<ResourceId> idList = new ArrayList<ResourceId>();
        String xpath = String.format("//wfs:%sResults/wfs:Feature/fes:ResourceId", action.toString());
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/wfs/2.0", "wfs");
        nsBindings.put("http://www.opengis.net/fes/2.0", "fes");
        try {
            NodeList idNodes = XMLUtils.evaluateXPath(entity, xpath, nsBindings);
            for (int i = 0; i < idNodes.getLength(); ++i) {
                Element idElem = (Element)idNodes.item(i);
                ResourceId id = new ResourceId(idElem.getAttribute("rid"));
                if (!idElem.getAttribute("previousRid").isEmpty()) {
                    id.setPreviousRid(idElem.getAttribute("previousRid"));
                }
                if (!idElem.getAttribute("version").isEmpty()) {
                    id.setVersion(idElem.getAttribute("version"));
                }
                idList.add(id);
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return idList;
    }

    Node createFeatureInstance(QName featureType) {
        Document entity = this.wfsClient.getFeatureByType(featureType, 1, null);
        NodeList features = entity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        if (features.getLength() == 0) {
            throw new NullPointerException("Unable to obtain feature instance of type " + featureType);
        }
        Element feature = (Element)features.item(0);
        feature.setAttributeNS("http://www.opengis.net/gml/3.2", "gml:id", "id-" + System.currentTimeMillis());
        InsertTests.insertRandomIdentifier(feature);
        return feature.cloneNode(true);
    }

    public static UUID insertRandomIdentifier(Element feature) {
        QName propName = new QName("http://www.opengis.net/gml/3.2", "identifier");
        Element identifier = XMLUtils.createElement(propName);
        identifier.setAttribute("codeSpace", "http://cite.opengeospatial.org/");
        UUID uuid = UUID.randomUUID();
        identifier.setTextContent(uuid.toString());
        WFSMessage.insertGMLProperty(feature, identifier);
        return uuid;
    }

    public static String addRandomName(Element feature) {
        QName gmlName = new QName("http://www.opengis.net/gml/3.2", "name");
        Element name = XMLUtils.createElement(gmlName);
        name.setAttribute("codeSpace", "http://cite.opengeospatial.org/");
        String value = UUID.randomUUID().toString().replaceAll("-", "");
        name.setTextContent(value.toString());
        WFSMessage.insertGMLProperty(feature, name);
        return value;
    }
}

