/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.util.Iterator;
import org.geotoolkit.util.collection.DeferringIterator;

final class OrderedIterator<T>
extends DeferringIterator<T> {
    final ClassLoader classLoader;

    OrderedIterator(ClassLoader classLoader, Iterator<T> iterator) {
        super(iterator);
        this.classLoader = classLoader;
    }

    @Override
    protected boolean isDeferred(T element) {
        if (element == null) {
            return false;
        }
        ClassLoader nc = element.getClass().getClassLoader();
        ClassLoader c = this.classLoader;
        while (c != null) {
            if ((c = c.getParent()) != nc) continue;
            return false;
        }
        for (c = nc; c != null; c = c.getParent()) {
            if (c != this.classLoader) continue;
            return false;
        }
        return true;
    }
}

