/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.io.TableAppender;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.geotoolkit.nio.IOUtilities;

public final class Synchronizer {
    private static final Level SELECT = Level.FINE;
    private static final Level UPDATE = Level.FINE;
    private final Connection source;
    private final Connection target;
    private transient DatabaseMetaData sourceMetadata;
    private transient DatabaseMetaData targetMetadata;
    public String sourceCatalog;
    public String targetCatalog;
    public String sourceSchema;
    public String targetSchema;
    private final Writer out;
    private boolean pretend;
    public volatile boolean cancel;

    public Synchronizer(Connection source, Connection target, Writer out) {
        this.source = source;
        this.target = target;
        this.out = out;
    }

    public Synchronizer(String source, String target) throws SQLException {
        this.source = DriverManager.getConnection(source);
        this.target = DriverManager.getConnection(target);
        this.out = IOUtilities.standardWriter();
        this.source.setReadOnly(true);
    }

    private static void appendTableName(StringBuilder buffer, String schema, String table, String quote) {
        buffer.append(quote);
        if (schema != null) {
            buffer.append(schema).append(quote).append('.').append(quote);
        }
        buffer.append(table).append(quote);
    }

    private static boolean contains(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    private String[] getPrimaryKeys(String table) throws SQLException {
        String[] columns;
        String catalog = this.targetCatalog;
        String schema = this.targetSchema;
        try (ResultSet results = this.targetMetadata.getPrimaryKeys(catalog, schema, table);){
            columns = CharSequences.EMPTY_ARRAY;
            while (results.next()) {
                if (catalog != null && !catalog.equals(results.getString("TABLE_CAT")) || schema != null && !schema.equals(results.getString("TABLE_SCHEM")) || !table.equals(results.getString("TABLE_NAME"))) continue;
                String column = results.getString("COLUMN_NAME");
                short index = results.getShort("KEY_SEQ");
                if (index > columns.length) {
                    columns = Arrays.copyOf(columns, (int)index);
                }
                columns[index - 1] = column;
            }
        }
        return columns;
    }

    private static int getColumnIndex(ResultSetMetaData metadata, String column) throws SQLException {
        int count = metadata.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            if (!column.equals(metadata.getColumnName(i))) continue;
            return i;
        }
        return 0;
    }

    private static int[] getColumnIndex(ResultSetMetaData metadata, String[] columns) throws SQLException {
        int[] index = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            index[i] = Synchronizer.getColumnIndex(metadata, columns[i]);
        }
        return index;
    }

    private void delete(String table, String condition) throws SQLException {
        String quote = this.targetMetadata.getIdentifierQuoteString();
        StringBuilder buffer = new StringBuilder("DELETE FROM ");
        Synchronizer.appendTableName(buffer, this.targetSchema, table, quote);
        if (condition != null) {
            buffer.append(" WHERE ").append(condition);
        }
        String sql = buffer.toString();
        try (Statement targetStatement = this.target.createStatement();){
            int count = this.pretend ? 0 : targetStatement.executeUpdate(sql);
            Synchronizer.log(UPDATE, "delete", sql + "\n" + count + " lignes supprim\u00e9es.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(String table, String condition, Policy onExisting) throws SQLException, IOException {
        String quoteSource = this.sourceMetadata.getIdentifierQuoteString();
        StringBuilder buffer = new StringBuilder("SELECT * FROM ");
        Synchronizer.appendTableName(buffer, this.sourceSchema, table, quoteSource);
        if (condition != null) {
            buffer.append(" WHERE ").append(condition);
        }
        String sql = buffer.toString();
        TableAppender mismatchs = null;
        try (Statement existing = null;
             Statement sourceStatement = this.source.createStatement();
             ResultSet sourceResultSet = sourceStatement.executeQuery(sql);){
            int i;
            ResultSetMetaData metadata = sourceResultSet.getMetaData();
            String[] sourceColumns = new String[metadata.getColumnCount()];
            int i2 = 0;
            while (i2 < sourceColumns.length) {
                sourceColumns[i2++] = metadata.getColumnName(i2);
            }
            Synchronizer.log(SELECT, "insert", sql);
            String[] pkColumns = this.getPrimaryKeys(table);
            int[] pkSourceIndex = new int[pkColumns.length];
            for (int i3 = 0; i3 < pkColumns.length; ++i3) {
                String name = pkColumns[i3];
                pkSourceIndex[i3] = Synchronizer.getColumnIndex(metadata, name);
                if (pkSourceIndex[i3] != 0) continue;
                throw new SQLException("Primary key \"" + name + "\" defined in the target \"" + table + "\" table is not found in the source table.");
            }
            int[] nonpkSourceIndex = new int[sourceColumns.length - pkSourceIndex.length];
            int i4 = 0;
            int j = 0;
            while (i4 < sourceColumns.length) {
                if (Synchronizer.contains(pkSourceIndex, ++i4)) continue;
                nonpkSourceIndex[j++] = i4;
            }
            assert (!Synchronizer.contains(nonpkSourceIndex, 0));
            boolean update = nonpkSourceIndex.length != 0 && onExisting == Policy.INSERT_OR_UPDATE;
            String quoteTarget = this.targetMetadata.getIdentifierQuoteString();
            if (pkColumns.length != 0 && onExisting != Policy.DELETE_BEFORE_INSERT) {
                String name;
                int i5;
                buffer.setLength(0);
                Synchronizer.appendTableName(buffer.append(update ? "UPDATE " : "SELECT * FROM "), this.targetSchema, table, quoteTarget);
                if (update) {
                    buffer.append(" SET ");
                    boolean afterFirst = false;
                    for (i5 = 0; i5 < nonpkSourceIndex.length; ++i5) {
                        if (afterFirst) {
                            buffer.append(',');
                        } else {
                            afterFirst = true;
                        }
                        name = sourceColumns[nonpkSourceIndex[i5] - 1];
                        buffer.append(quoteTarget).append(name).append(quoteTarget).append("=?");
                    }
                }
                String separator = " WHERE ";
                for (i5 = 0; i5 < pkColumns.length; ++i5) {
                    name = pkColumns[i5];
                    buffer.append(separator).append(quoteTarget).append(name).append(quoteTarget).append("=?");
                    separator = " AND ";
                }
                sql = buffer.toString();
                existing = this.target.prepareStatement(sql);
            }
            buffer.setLength(0);
            Synchronizer.appendTableName(buffer.append("INSERT INTO "), this.targetSchema, table, quoteTarget);
            buffer.append(" (");
            for (i = 0; i < sourceColumns.length; ++i) {
                if (i != 0) {
                    buffer.append(',');
                }
                buffer.append(quoteTarget).append(sourceColumns[i]).append(quoteTarget);
            }
            buffer.append(") VALUES (");
            for (i = 0; i < sourceColumns.length; ++i) {
                if (i != 0) {
                    buffer.append(',');
                }
                buffer.append('?');
            }
            sql = buffer.append(')').toString();
            try (PreparedStatement insertStatement = this.target.prepareStatement(sql);){
                int[] sourceToTarget = null;
                Object[] primaryKeyValues = new Object[pkColumns.length];
                while (sourceResultSet.next()) {
                    int count;
                    if (this.cancel) {
                        break;
                    }
                    if (existing != null) {
                        Object value;
                        int i6;
                        int param = 0;
                        if (update) {
                            for (i6 = 0; i6 < nonpkSourceIndex.length; ++i6) {
                                value = sourceResultSet.getObject(nonpkSourceIndex[i6]);
                                existing.setObject(++param, value);
                            }
                        }
                        for (i6 = 0; i6 < pkSourceIndex.length; ++i6) {
                            value = sourceResultSet.getObject(pkSourceIndex[i6]);
                            existing.setObject(++param, value);
                            primaryKeyValues[i6] = value;
                        }
                        int count2 = 0;
                        if (update) {
                            count2 = existing.executeUpdate();
                        } else {
                            try (ResultSet targetResultSet = existing.executeQuery();){
                                if (sourceToTarget == null) {
                                    sourceToTarget = Synchronizer.getColumnIndex(targetResultSet.getMetaData(), sourceColumns);
                                }
                                while (targetResultSet.next()) {
                                    for (int i7 = 0; i7 < sourceToTarget.length; ++i7) {
                                        String target;
                                        String source;
                                        int index = sourceToTarget[i7];
                                        if (index == 0 || Objects.equals(source = sourceResultSet.getString(i7 + 1), target = targetResultSet.getString(index))) continue;
                                        if (mismatchs == null) {
                                            mismatchs = this.createMismatchTable(table, pkColumns);
                                        } else {
                                            mismatchs.nextLine();
                                        }
                                        for (int j2 = 0; j2 < primaryKeyValues.length; ++j2) {
                                            mismatchs.append((CharSequence)String.valueOf(primaryKeyValues[j2]));
                                            mismatchs.nextColumn();
                                        }
                                        mismatchs.append((CharSequence)sourceColumns[i7]);
                                        mismatchs.nextColumn();
                                        mismatchs.append((CharSequence)source);
                                        mismatchs.nextColumn();
                                        mismatchs.append((CharSequence)target);
                                        mismatchs.nextLine();
                                    }
                                    ++count2;
                                }
                            }
                        }
                        if (count2 != 0) continue;
                    }
                    for (int i8 = 1; i8 <= sourceColumns.length; ++i8) {
                        insertStatement.setObject(i8, sourceResultSet.getObject(i8));
                    }
                    int n = count = this.pretend ? 1 : insertStatement.executeUpdate();
                    if (count == 1) {
                        Synchronizer.log(UPDATE, "insert", insertStatement.toString());
                        continue;
                    }
                    Synchronizer.log(Level.WARNING, "insert", count + " enregistrements ajout\u00e9s.");
                }
            }
        }
        if (mismatchs != null) {
            mismatchs.nextLine('\u2500');
            mismatchs.flush();
        }
    }

    private TableAppender createMismatchTable(String table, String[] pkColumns) throws IOException {
        String lineSeparator = System.lineSeparator();
        this.out.write(lineSeparator);
        this.out.write(table);
        this.out.write(lineSeparator);
        TableAppender mismatchs = new TableAppender((Appendable)this.out);
        mismatchs.nextLine('\u2500');
        for (int j = 0; j < pkColumns.length; ++j) {
            mismatchs.append((CharSequence)pkColumns[j]);
            mismatchs.nextColumn();
        }
        mismatchs.append((CharSequence)"Colonne");
        mismatchs.nextColumn();
        mismatchs.append((CharSequence)"Valeur \u00e0 copier");
        mismatchs.nextColumn();
        mismatchs.append((CharSequence)"Valeur existante");
        mismatchs.nextLine();
        mismatchs.nextLine('\u2500');
        return mismatchs;
    }

    private void copy(String table, Map<String, String> tables, Policy onExisting) throws SQLException, IOException {
        String condition = tables.remove(table);
        if (condition != null && (condition = condition.trim()).isEmpty()) {
            condition = null;
        }
        if (onExisting == Policy.DELETE_BEFORE_INSERT) {
            this.delete(table, condition);
        }
        String catalog = this.targetCatalog;
        String schema = this.targetSchema;
        try (ResultSet dependencies = this.targetMetadata.getImportedKeys(catalog, schema, table);){
            while (dependencies.next()) {
                String dependency = dependencies.getString("PKTABLE_CAT");
                if (catalog != null && !catalog.equals(dependency)) continue;
                dependency = dependencies.getString("PKTABLE_SCHEM");
                if (schema != null && !schema.equals(dependency) || !tables.containsKey(dependency = dependencies.getString("PKTABLE_NAME"))) continue;
                this.copy(dependency, tables, onExisting);
            }
        }
        this.insert(table, condition, onExisting);
    }

    public void copy(Policy onExisting, Map<String, String> tables) throws SQLException, IOException {
        String catalog = this.targetCatalog;
        String schema = this.targetSchema;
        this.sourceMetadata = this.source.getMetaData();
        this.targetMetadata = this.target.getMetaData();
        block6: while (!tables.isEmpty()) {
            String table2;
            block7: for (String table2 : tables.keySet()) {
                if (this.cancel) break block6;
                ResultSet dependents = this.targetMetadata.getExportedKeys(catalog, schema, table2);
                try {
                    while (dependents.next()) {
                        if (catalog != null && !catalog.equals(dependents.getString("FKTABLE_CAT")) || schema != null && !schema.equals(dependents.getString("FKTABLE_SCHEM"))) continue;
                        String dependent = dependents.getString("FKTABLE_NAME");
                        if (tables.containsKey(dependent)) continue block7;
                    }
                }
                finally {
                    if (dependents == null) continue;
                    dependents.close();
                    continue;
                }
                this.copy(table2, tables, onExisting);
                continue block6;
            }
            Iterator<String> iterator = tables.keySet().iterator();
            if (!iterator.hasNext()) continue;
            table2 = iterator.next();
            this.copy(table2, tables, onExisting);
        }
    }

    public void copy(Policy onExisting, String ... tables) throws SQLException, IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(Containers.hashMapCapacity((int)tables.length));
        for (String table : tables) {
            map.put(table, null);
        }
        this.copy(onExisting, map);
    }

    public void close() throws SQLException {
        this.sourceMetadata = null;
        this.targetMetadata = null;
        this.target.close();
        this.source.close();
    }

    private static void log(Level level, String method, String message) {
        LogRecord record = new LogRecord(level, message);
        record.setSourceClassName(Synchronizer.class.getName());
        record.setSourceMethodName(method);
        Logger.getLogger("org.geotoolkit.sql").log(record);
    }

    public static enum Policy {
        INSERT_ONLY,
        INSERT_OR_UPDATE,
        DELETE_BEFORE_INSERT;

    }
}

