/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import org.apache.sis.util.ArgumentChecks;

public class SeekableByteArrayChannel
implements SeekableByteChannel {
    private byte[] data;
    private int limit;
    private int position;
    private boolean isClosed;

    public SeekableByteArrayChannel() {
        this(new byte[1000000], 0);
    }

    public SeekableByteArrayChannel(byte[] data) {
        this(data, data.length);
    }

    public SeekableByteArrayChannel(byte[] data, int limit) {
        ArgumentChecks.ensureNonNull((String)"SeekableByteArrayChannel : data", (Object)data);
        ArgumentChecks.ensureBetween((String)"SeekableByteArrayChannel : limit", (int)0, (int)data.length, (int)limit);
        this.data = data;
        this.limit = limit;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.ensureOpen();
        if (this.position >= this.limit) {
            return -1;
        }
        int length = StrictMath.min(dst.remaining(), this.limit - this.position);
        dst.put(this.data, this.position, length);
        this.position += length;
        return length;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.ensureOpen();
        int length = src.remaining();
        this.ensureDataContain(length);
        src.get(this.data, this.position, length);
        this.position += length;
        this.limit = StrictMath.max(this.limit, this.position);
        return length;
    }

    @Override
    public long position() throws IOException {
        this.ensureOpen();
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.ensureOpen();
        ArgumentChecks.ensureBetween((String)"position", (long)0L, (long)this.size(), (long)newPosition);
        this.position = (int)newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        this.ensureOpen();
        return this.limit;
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        this.ensureOpen();
        ArgumentChecks.ensureBetween((String)"position", (long)0L, (long)this.limit, (long)size);
        this.limit = (int)size;
        return this;
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
    }

    private void ensureDataContain(int length) {
        ArgumentChecks.ensurePositive((String)"ensure data contain : length", (int)length);
        if (length > this.data.length - this.limit) {
            this.data = Arrays.copyOf(this.data, StrictMath.max(1000000, this.data.length << 1));
        }
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.limit);
    }
}

