/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.nio;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.regex.Pattern;

public class PosixDirectoryFilter
implements DirectoryStream.Filter<Path> {
    private final Pattern pattern;

    public PosixDirectoryFilter(String pattern) {
        this(pattern, Boolean.FALSE);
    }

    public PosixDirectoryFilter(String pattern, boolean caseInsensitive) {
        int length = pattern.length();
        StringBuilder buffer = new StringBuilder(length + 8);
        block4: for (int i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                switch (c) {
                    case '?': {
                        buffer.append('.');
                        continue block4;
                    }
                    case '*': {
                        buffer.append(".*");
                        continue block4;
                    }
                    default: {
                        buffer.append('\\');
                    }
                }
            }
            buffer.append(c);
        }
        this.pattern = caseInsensitive ? Pattern.compile(buffer.toString(), 2) : Pattern.compile(buffer.toString());
    }

    @Override
    public boolean accept(Path entry) throws IOException {
        return entry != null && this.pattern.matcher(entry.getFileName().toString()).matches();
    }
}

