/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.util.Arrays;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

@Deprecated
public final class LinearInterpolator1D
extends AbstractMathTransform1D {
    private final double[] antecedent;
    private final double[] values;
    private boolean isIncreaseOrder = true;
    private final int l;

    private LinearInterpolator1D(double[] values) {
        ArgumentChecks.ensureNonNull((String)"values", (Object)values);
        this.l = values.length;
        if (this.l < 2) {
            throw new IllegalArgumentException("table must have more than only two values");
        }
        this.values = values;
        this.antecedent = new double[this.l];
        for (int v = 0; v < this.l; ++v) {
            this.antecedent[v] = v;
        }
    }

    private LinearInterpolator1D(double[] antecedents, double[] values) {
        ArgumentChecks.ensureNonNull((String)"values", (Object)values);
        ArgumentChecks.ensureNonNull((String)"antecedents", (Object)antecedents);
        this.l = antecedents.length;
        if (this.l < 2) {
            throw new IllegalArgumentException("table must have more than only two values");
        }
        if (this.l != values.length) {
            throw new IllegalArgumentException("antecedents and values table must have same length");
        }
        if (!ArraysExt.isSorted((double[])antecedents, (boolean)true)) {
            double[] antecedent2 = new double[this.l];
            int id = this.l;
            for (int i = 0; i < this.l; ++i) {
                antecedent2[i] = antecedents[--id];
            }
            if (!ArraysExt.isSorted((double[])antecedent2, (boolean)true)) {
                throw new IllegalArgumentException("antecedents table must be strictly increasing or decreasing");
            }
            this.isIncreaseOrder = false;
        }
        this.antecedent = antecedents;
        this.values = values;
    }

    public double transform(double d) throws TransformException {
        int idn1;
        int idn;
        int idb;
        int ida;
        if (this.isIncreaseOrder) {
            ida = 0;
            idb = this.l - 1;
            idn = 0;
            idn1 = 1;
        } else {
            ida = this.l - 1;
            idb = 0;
            idn = 1;
            idn1 = 0;
        }
        if (d <= this.antecedent[ida]) {
            return this.values[ida];
        }
        if (d >= this.antecedent[idb]) {
            return this.values[idb];
        }
        for (int id = 0; id < this.l - 1; ++id) {
            double x0 = this.antecedent[idn];
            double x1 = this.antecedent[idn1];
            if (d == x0) {
                return this.values[idn];
            }
            if (d == x1) {
                return this.values[idn1];
            }
            if (d > this.antecedent[idn] && d < this.antecedent[idn1]) {
                return this.values[idn] + (this.values[idn1] - this.values[idn]) * ((d - x0) / (x1 - x0));
            }
            ++idn;
            ++idn1;
        }
        return 0.0;
    }

    public double derivative(double d) throws TransformException {
        int idn1;
        int idn;
        if (this.isIncreaseOrder) {
            idn = 0;
            idn1 = 1;
            if (d < this.antecedent[0] || d >= this.antecedent[this.l - 1]) {
                return 0.0;
            }
        } else {
            idn = 1;
            idn1 = 0;
            if (d <= this.antecedent[this.l - 1] || d > this.antecedent[0]) {
                return 0.0;
            }
        }
        for (int id = 0; id < this.l; ++id) {
            if (d > this.antecedent[idn] && d < this.antecedent[idn1] || d == this.antecedent[id]) {
                return (this.values[idn1] - this.values[idn]) / (this.antecedent[idn1] - this.antecedent[idn]);
            }
            ++idn;
            ++idn1;
        }
        return 0.0;
    }

    public MathTransform1D inverse() throws NoninvertibleTransformException {
        if (!ArraysExt.isSorted((double[])this.values, (boolean)true)) {
            double[] values2 = new double[this.l];
            int id = this.l;
            for (int i = 0; i < this.l; ++i) {
                values2[i] = this.values[--id];
            }
            if (!ArraysExt.isSorted((double[])values2, (boolean)true)) {
                throw new NoninvertibleTransformException("non inversible");
            }
        }
        return new LinearInterpolator1D(this.values, this.antecedent);
    }

    public boolean isIdentity() {
        return Arrays.equals(this.antecedent, this.values);
    }

    public static LinearInterpolator1D create(double[] values) {
        return new LinearInterpolator1D(values);
    }

    public static LinearInterpolator1D create(double[] antecedents, double[] values) {
        return new LinearInterpolator1D(antecedents, values);
    }
}

