/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import org.apache.sis.io.LineAppender;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;

public final class Exceptions
extends Static {
    private static final int TAB_WIDTH = 4;

    private Exceptions() {
    }

    public static boolean isValidMessage(String message) {
        if (message == null) {
            return false;
        }
        return !(message = message.trim()).isEmpty() && !message.equalsIgnoreCase("null");
    }

    public static String formatStackTrace(Throwable exception) {
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        StringBuilder buffer = new StringBuilder();
        LineAppender formatter = new LineAppender((Appendable)buffer);
        formatter.setTabulationWidth(4);
        try {
            formatter.append((CharSequence)writer.toString());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return buffer.toString();
    }

    public static void paintStackTrace(Graphics2D graphics, Rectangle widgetBounds, Throwable exception) {
        GlyphVector line;
        Rectangle2D rect;
        String message = Exceptions.formatStackTrace(exception);
        double width = 0.0;
        double height = 0.0;
        ArrayList<GlyphVector> glyphs = new ArrayList<GlyphVector>();
        ArrayList<Rectangle2D> bounds = new ArrayList<Rectangle2D>();
        int length = message.length();
        Font font = graphics.getFont();
        FontRenderContext context = graphics.getFontRenderContext();
        int i = 0;
        while (i < length) {
            int irn;
            double w;
            int ir = message.indexOf(13, i);
            int in = message.indexOf(10, i);
            if (ir < 0) {
                ir = length;
            }
            if (in < 0) {
                in = length;
            }
            if ((w = (rect = (line = font.createGlyphVector(context, message.substring(i, irn = Math.min(ir, in)))).getVisualBounds()).getWidth()) > width) {
                width = w;
            }
            height += rect.getHeight();
            glyphs.add(line);
            bounds.add(rect);
            i = (Math.abs(ir - in) <= 1 ? Math.max(ir, in) : irn) + 1;
        }
        float xpos = (float)widgetBounds.x + (float)(0.5 * Math.max(0.0, (double)widgetBounds.width - width));
        float ypos = (float)widgetBounds.y + (float)(0.5 * Math.max(0.0, (double)widgetBounds.height - height));
        int size = glyphs.size();
        for (int i2 = 0; i2 < size; ++i2) {
            line = (GlyphVector)glyphs.get(i2);
            rect = (Rectangle2D)bounds.get(i2);
            ypos = (float)((double)ypos + rect.getHeight());
            graphics.drawGlyphVector(line, xpos, ypos);
        }
    }

    public static void show(Component owner, Throwable exception) throws UnsupportedOperationException {
        Exceptions.show(new Object[]{owner, exception});
    }

    public static void show(Component owner, Throwable exception, String message) throws UnsupportedOperationException {
        Exceptions.show(new Object[]{owner, exception, message});
    }

    private static void show(Object[] arguments) throws UnsupportedOperationException {
        Class[] types = new Class[arguments.length];
        switch (types.length) {
            default: {
                types[2] = String.class;
            }
            case 2: {
                types[1] = Throwable.class;
            }
            case 1: {
                types[0] = Component.class;
            }
            case 0: 
        }
        try {
            Class.forName("org.geotoolkit.internal.swing.ExceptionMonitor").getMethod("show", types).invoke(null, arguments);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException(Errors.format((short)99, "geotk-widgets-swing"), e);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
    }
}

