/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.version;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.geotoolkit.version.Version;
import org.geotoolkit.version.VersionHistory;
import org.geotoolkit.version.VersioningException;

public abstract class AbstractVersionHistory
implements VersionHistory {
    private static final TimeZone GMT0 = TimeZone.getTimeZone("GMT+0");

    @Override
    public Version getVersion(String label) throws VersioningException {
        for (Version v : this.list()) {
            if (!v.getLabel().equals(label)) continue;
            return v;
        }
        throw new VersioningException("No version with given label.");
    }

    @Override
    public Version getVersion(Date date) throws VersioningException {
        List<Version> lst = this.list();
        Collections.sort(lst, new VersionComparator());
        GregorianCalendar vCal = new GregorianCalendar(GMT0);
        GregorianCalendar rCal = new GregorianCalendar(GMT0);
        rCal.setTime(date);
        for (Version v : lst) {
            vCal.setTime(v.getDate());
            if (rCal.getTimeInMillis() < vCal.getTimeInMillis()) continue;
            return v;
        }
        return lst.isEmpty() ? null : lst.get(0);
    }

    public class VersionComparator
    implements Comparator<Version> {
        @Override
        public int compare(Version o1, Version o2) {
            return o2.getDate().compareTo(o1.getDate());
        }
    }
}

