/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.dgiwg.testsuite.getcapabilities;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.wfs20.core.dgiwg.testsuite.WfsBaseFixture;
import java.util.Arrays;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GetCapabilitiesAccessConstraintTest
extends WfsBaseFixture {
    private static final List<String> EXPECTED_ACCESS_CONSTRAINTS = Arrays.asList("unclassified", "restricted", "confidential", "secret", "topSecret");

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.2.1., S.19, Requirement 4")
    public void wfsCapabilitiesAccessConstraintsExists() {
        String xPathXml = "//wfs:WFS_Capabilities/ows:ServiceIdentification/ows:AccessConstraints  != ''";
        ETSAssert.assertXPath((String)xPathXml, (Node)this.wfsMetadata, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.2.1., S.19, Requirement 4", dependsOnMethods={"wfsCapabilitiesAccessConstraintsExists"})
    public void wfsCapabilitiesAccessConstraintsContainsValueFromDMF() throws XPathFactoryConfigurationException, XPathExpressionException {
        String accessConstraints = this.parseAccessConstraints(this.wfsMetadata);
        Assert.assertTrue((boolean)EXPECTED_ACCESS_CONSTRAINTS.contains(accessConstraints), (String)("AccessConstraints are not valid, must be one of " + EXPECTED_ACCESS_CONSTRAINTS + " but was " + accessConstraints));
    }

    private String parseAccessConstraints(Document wfsCapabilities) throws XPathFactoryConfigurationException, XPathExpressionException {
        String xPathAccessConstraints = "//wfs:WFS_Capabilities/ows:ServiceIdentification/ows:AccessConstraints ";
        XPath xpath = this.createXPath();
        return (String)xpath.evaluate(xPathAccessConstraints, wfsCapabilities, XPathConstants.STRING);
    }
}

