/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.utils;

import jakarta.xml.bind.DatatypeConverter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public final class TimeUtils {
    private TimeUtils() {
    }

    public static Calendar[] calculateDateRange(String[] dateValues) {
        List<Calendar> parseAndSortValues = TimeUtils.parseAndSortValues(dateValues);
        if (parseAndSortValues.isEmpty()) {
            return new Calendar[0];
        }
        if (parseAndSortValues.size() == 1) {
            Calendar value = parseAndSortValues.get(0);
            return new Calendar[]{value, value};
        }
        Calendar min = parseAndSortValues.get(0);
        Calendar max = parseAndSortValues.get(parseAndSortValues.size() - 1);
        return new Calendar[]{min, max};
    }

    public static String calculateValueBetween(Calendar[] range) {
        Calendar min = range[0];
        Calendar max = range[1];
        if (min.equals(max)) {
            return DatatypeConverter.printDateTime((Calendar)min);
        }
        return TimeUtils.calculateValueBetween(min.getTimeInMillis(), max.getTimeInMillis());
    }

    public static String calculateValueBetween(long minTimeInMillis, long maxTimeInMillis) {
        long midTimeInMillis = minTimeInMillis + (maxTimeInMillis - minTimeInMillis) / 2L;
        Calendar midTime = Calendar.getInstance();
        midTime.setTimeInMillis(midTimeInMillis);
        return DatatypeConverter.printDateTime((Calendar)midTime);
    }

    private static List<Calendar> parseAndSortValues(String[] values) {
        if (null == values || values.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Calendar> dateValues = new ArrayList<Calendar>();
        for (String value : values) {
            if (value.indexOf(84) > 0) {
                dateValues.add(DatatypeConverter.parseDateTime((String)value));
                continue;
            }
            dateValues.add(DatatypeConverter.parseDate((String)value));
        }
        Collections.sort(dateValues);
        return dateValues;
    }
}

