/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.wfs20.testsuite.basic.filter;

import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.DatatypeConverter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyIsBetweenOperatorTests
extends QueryFilterFixture {
    @Test(description="See ISO 19143: 7.7.3.7", dataProvider="protocol-featureType")
    public void propertyIsBetween(ProtocolBinding binding, QName featureType) {
        try {
            Map<XSElementDeclaration, String[]> propRangeMap = this.findNumericAndTemporalFeaturePropertyValue(featureType);
            if (propRangeMap.isEmpty()) {
                throw new SkipException("No numeric or temporal property values found for " + featureType);
            }
            Map.Entry<XSElementDeclaration, String[]> propRange = propRangeMap.entrySet().iterator().next();
            String propValueMin = propRange.getValue()[0];
            String propValueMax = propRange.getValue()[1];
            XSElementDeclaration propDecl = propRange.getKey();
            QName propName = new QName(propDecl.getNamespace(), propDecl.getName());
            WFSMessage.appendSimpleQuery((Document)this.reqEntity, (QName[])new QName[]{featureType});
            this.addPropertyIsBetweenPredicate(this.reqEntity, propName, propValueMin, propValueMax);
            Response rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
            this.rspEntity = this.extractBodyAsDocument(rsp);
            Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get((String)"UnexpectedStatus"));
            NodeList features = this.rspEntity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
            QName dataType = AppSchemaUtils.getBuiltInDatatype((XSElementDeclaration)propDecl);
            String propTypeName = dataType.getLocalPart();
            String xpath = String.format("xs:%s(ns1:%s) lt xs:%s('%s') and xs:%s(ns1:%s) gt xs:%s('%s')", propTypeName, propName.getLocalPart(), propTypeName, propValueMax, propTypeName, propName.getLocalPart(), propTypeName, propValueMin);
            HashMap<String, String> nsBindings = new HashMap<String, String>();
            nsBindings.put(propName.getNamespaceURI(), "ns1");
            for (int i = 0; i < features.getLength(); ++i) {
                ETSAssert.assertXPath2((String)xpath, (Source)new DOMSource(features.item(i)), nsBindings);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test(description="See ISO 19143: 8.3", dataProvider="protocol-binding")
    public void invalidPropertyReference(ProtocolBinding binding) {
        try {
            QName propName = new QName("http://example.org", "undefined", "ex");
            QName featureType = this.retrieveRandomFeatureType();
            WFSMessage.appendSimpleQuery((Document)this.reqEntity, (QName[])new QName[]{featureType});
            this.addPropertyIsBetweenPredicate(this.reqEntity, propName, "1355941270", "1355941271");
            Response rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
            this.rspEntity = (Document)rsp.readEntity(Document.class);
            Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get((String)"UnexpectedStatus"));
            String xpath = "//ows:Exception[@exceptionCode='InvalidParameterValue']";
            ETSAssert.assertXPath((String)xpath, (Node)this.rspEntity, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<XSElementDeclaration, String[]> findNumericAndTemporalFeaturePropertyValue(QName featureType) {
        Set<XSTypeDefinition> dataTypes = this.getNumericDataTypes(this.model);
        dataTypes.addAll(this.getTemporalDataTypes(this.model));
        Map<XSElementDeclaration, String[]> propRangeMap = this.findFeaturePropertyValue(this.model, featureType, dataTypes);
        return propRangeMap;
    }

    private void addPropertyIsBetweenPredicate(Document request, QName propertyName, Object lowerBoundaryValue, Object upperBoundaryValue) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        if (null == propertyName) {
            throw new IllegalArgumentException("propertyName is required.");
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
        queryElem.appendChild(filter);
        Element predicate = request.createElementNS("http://www.opengis.net/fes/2.0", "PropertyIsBetween");
        filter.appendChild(predicate);
        this.addValueReference(request, propertyName, predicate);
        this.addBoundary(request, "LowerBoundary", lowerBoundaryValue, predicate);
        this.addBoundary(request, "UpperBoundary", upperBoundaryValue, predicate);
    }

    private void addValueReference(Document request, QName propertyName, Element predicate) {
        Element valueRef = request.createElementNS("http://www.opengis.net/fes/2.0", "ValueReference");
        predicate.appendChild(valueRef);
        String prefix = propertyName.getPrefix().length() > 0 ? propertyName.getPrefix() : "tns";
        String nsURI = request.lookupNamespaceURI(prefix);
        if (null == nsURI) {
            valueRef.setAttribute("xmlns:" + prefix, propertyName.getNamespaceURI());
        }
        valueRef.setTextContent(prefix + ":" + propertyName.getLocalPart());
    }

    private void addBoundary(Document request, String boundaryName, Object literalValue, Element predicate) {
        Element boundaryElem = request.createElementNS("http://www.opengis.net/fes/2.0", boundaryName);
        predicate.appendChild(boundaryElem);
        Element literalElem = request.createElementNS("http://www.opengis.net/fes/2.0", "Literal");
        if (String.class.isInstance(literalValue)) {
            literalElem.setTextContent((String)literalValue);
        } else {
            Document literalDoc = (Document)literalValue;
            literalElem.appendChild(request.adoptNode(literalDoc.getDocumentElement()));
        }
        boundaryElem.appendChild(literalElem);
    }

    private Map<XSElementDeclaration, String[]> findFeaturePropertyValue(XSModel model, QName featureType, Set<XSTypeDefinition> dataTypes) {
        XSTypeDefinition dataType;
        List featureProps = null;
        Iterator<XSTypeDefinition> iterator = dataTypes.iterator();
        while (iterator.hasNext() && (featureProps = AppSchemaUtils.getFeaturePropertiesByType((XSModel)model, (QName)featureType, (XSTypeDefinition)(dataType = iterator.next()))).isEmpty()) {
        }
        ListIterator listItr = featureProps.listIterator(featureProps.size());
        XSElementDeclaration prop = null;
        Object[] valueRange = null;
        while (listItr.hasPrevious()) {
            prop = (XSElementDeclaration)listItr.previous();
            QName propName = new QName(prop.getNamespace(), prop.getName());
            List valueList = this.dataSampler.getSimplePropertyValues(featureType, propName, null);
            if (valueList.isEmpty()) continue;
            String[] values = new String[valueList.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (String)valueList.get(i);
            }
            QName datatype = AppSchemaUtils.getBuiltInDatatype((XSElementDeclaration)prop);
            valueRange = this.calculateRange(values, datatype);
            TestSuiteLogger.log((Level)Level.FINE, (String)String.format("Found property values of %s, %s %n %s", featureType, propName, Arrays.toString(valueRange)));
            break;
        }
        HashMap<XSElementDeclaration, String[]> map = new HashMap<XSElementDeclaration, String[]>();
        if (null != valueRange) {
            map.put(prop, (String[])valueRange);
        }
        return map;
    }

    private String[] calculateRange(String[] values, QName datatype) {
        this.sortValues(values);
        HashSet integerDatatypes = new HashSet();
        Collections.addAll(integerDatatypes, "integer", "nonPositiveInteger", "nonNegativeInteger", "long", "int");
        if (integerDatatypes.contains(datatype.getLocalPart())) {
            for (int i = 0; i < values.length; ++i) {
                int intValue = Double.valueOf(values[i]).intValue();
                values[i] = Integer.toString(intValue);
            }
        }
        return new String[]{values[0], values[values.length - 1]};
    }

    private void sortValues(String[] values) {
        DatatypeFactory dtFactory;
        int i;
        if (null == values || values.length == 0) {
            return;
        }
        Comparable<Double>[] objValues = null;
        try {
            objValues = new Double[values.length];
            for (int i2 = 0; i2 < objValues.length; ++i2) {
                objValues[i2] = Double.valueOf(values[i2]);
            }
            Arrays.sort(objValues);
        }
        catch (NumberFormatException nfe) {
            objValues = new Calendar[values.length];
            for (i = 0; i < objValues.length; ++i) {
                objValues[i] = values[i].indexOf(84) > 0 ? DatatypeConverter.parseDateTime((String)values[i]) : DatatypeConverter.parseDate((String)values[i]);
            }
            Arrays.sort(objValues);
        }
        try {
            dtFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        for (i = 0; i < values.length; ++i) {
            if (GregorianCalendar.class.isInstance(objValues[i])) {
                GregorianCalendar gCal = (GregorianCalendar)objValues[i];
                values[i] = dtFactory.newXMLGregorianCalendar(gCal).normalize().toString();
                continue;
            }
            values[i] = objValues[i].toString();
        }
    }

    private Set<XSTypeDefinition> getNumericDataTypes(XSModel model) {
        HashSet<XSTypeDefinition> dataTypes = new HashSet<XSTypeDefinition>();
        dataTypes.add(model.getTypeDefinition("decimal", "http://www.w3.org/2001/XMLSchema"));
        dataTypes.add(model.getTypeDefinition("double", "http://www.w3.org/2001/XMLSchema"));
        dataTypes.add(model.getTypeDefinition("float", "http://www.w3.org/2001/XMLSchema"));
        return dataTypes;
    }

    private Set<XSTypeDefinition> getTemporalDataTypes(XSModel model) {
        HashSet<XSTypeDefinition> dataTypes = new HashSet<XSTypeDefinition>();
        dataTypes.add(model.getTypeDefinition("dateTime", "http://www.w3.org/2001/XMLSchema"));
        dataTypes.add(model.getTypeDefinition("date", "http://www.w3.org/2001/XMLSchema"));
        dataTypes.add(model.getTypeDefinition("gYearMonth", "http://www.w3.org/2001/XMLSchema"));
        dataTypes.add(model.getTypeDefinition("gYear", "http://www.w3.org/2001/XMLSchema"));
        return dataTypes;
    }

    private QName retrieveRandomFeatureType() {
        Random rnd = new Random();
        int index = rnd.nextInt(this.featureTypes.size());
        QName featureType = (QName)this.featureTypes.get(index);
        return featureType;
    }
}

