/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.wfs20.testsuite.temporalfilter;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.wfs20.core.utils.ValidationUtils;
import de.latlon.ets.wfs20.core.wfs20.testsuite.temporalfilter.AbstractTemporalFilterTest;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtendedTemporalFilterTest
extends AbstractTemporalFilterTest {
    private static final List<String> EXPECTED_TEMPORAL_OPERATORS = Arrays.asList("After", "Before");

    @BeforeClass
    public void init(ITestContext testContext) {
        this.wfsSchema = ValidationUtils.createWFSSchema(this.wfsMetadata);
    }

    @DataProvider(name="protocol-featureType-additionalTemporalOperator")
    public Iterator<Object[]> protocolsAndFeatureTypesAndTemporalOperators() throws XPathFactoryConfigurationException, XPathExpressionException {
        return this.createDataProviderWithProtocolsFeatureTypesAndTemporalOperators(EXPECTED_TEMPORAL_OPERATORS);
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.3., S.24, Requirement 11")
    public void afterOperatorIsEnabled() {
        String xPathXml = "//wfs:WFS_Capabilities/fes:Filter_Capabilities/fes:Temporal_Capabilities/fes:TemporalOperators/fes:TemporalOperator[@name='After']";
        ETSAssert.assertXPath((String)xPathXml, (Node)this.wfsMetadata, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.3., S.24, Requirement 11")
    public void beforeOperatorIsEnabled() {
        String xPathXml = "//wfs:WFS_Capabilities/fes:Filter_Capabilities/fes:Temporal_Capabilities/fes:TemporalOperators/fes:TemporalOperator[@name='Before']";
        ETSAssert.assertXPath((String)xPathXml, (Node)this.wfsMetadata, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.3., S.24, Requirement 11", dataProvider="protocol-featureType-additionalTemporalOperator")
    public void withTemporalOperatorFilter(ProtocolBinding binding, AbstractTemporalFilterTest.FeatureTypeToPropertyAndValue featureTypeToPropertyAndValue, String temporalOperatorName) {
        this.checkIfDataProviderFoundTestableData(binding, featureTypeToPropertyAndValue, temporalOperatorName);
        Element valueRef = WFSMessage.createValueReference((XSElementDeclaration)featureTypeToPropertyAndValue.getProperty());
        WFSMessage.appendSimpleQuery((Document)this.reqEntity, (QName[])new QName[]{featureTypeToPropertyAndValue.getFeatureType()});
        this.addTemporalOperatorPredicate(this.reqEntity, temporalOperatorName, valueRef, featureTypeToPropertyAndValue.getValueRange());
        Response rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get((String)"UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp);
        ETSAssert.assertSchemaValid((Schema)this.wfsSchema, (Document)this.rspEntity);
    }
}

