/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.wfs20.testsuite.temporalfilter;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.wfs20.core.utils.ValidationUtils;
import de.latlon.ets.wfs20.core.wfs20.testsuite.temporalfilter.AbstractTemporalFilterTest;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TemporalFilterTest
extends AbstractTemporalFilterTest {
    private static final List<String> EXPECTED_TEMPORAL_OPERATORS = Arrays.asList("After", "Before", "Begins", "BegunBy", "TContains", "TEquals", "TOverlaps", "Meets", "OverlappedBy", "MetBy", "Ends", "EndedBy");

    @BeforeClass
    public void init(ITestContext testContext) {
        this.wfsSchema = ValidationUtils.createWFSSchema(this.wfsMetadata);
    }

    @DataProvider(name="protocol-featureType-temporalOperator")
    public Iterator<Object[]> protocolsAndFeatureTypesAndTemporalOperators() throws XPathFactoryConfigurationException, XPathExpressionException {
        return this.createDataProviderWithProtocolsFeatureTypesAndTemporalOperators(EXPECTED_TEMPORAL_OPERATORS);
    }

    @DataProvider(name="protocol-featureType-duringOperator")
    public Iterator<Object[]> protocolsAndFeatureTypesAndDuringOperator() throws XPathFactoryConfigurationException, XPathExpressionException {
        return this.createDataProviderWithProtocolsFeatureTypesAndTemporalOperators(Collections.singletonList("During"));
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.3., S.24, Requirement 10; OGC 09-026R2 Temporal Filter CC, A.10")
    public void implementsTemporalFilterIsEnabled() {
        String xPathXml = "//wfs:WFS_Capabilities/fes:Filter_Capabilities/fes:Conformance/fes:Constraint[@name='ImplementsTemporalFilter']/ows:DefaultValue = 'TRUE'";
        ETSAssert.assertXPath((String)xPathXml, (Node)this.wfsMetadata, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.3., S.24, Requirement 10; OGC 09-026R2 Temporal Filter CC, A.10")
    public void duringOperatorIsEnabled() {
        String xPathXml = "//wfs:WFS_Capabilities/fes:Filter_Capabilities/fes:Temporal_Capabilities/fes:TemporalOperators/fes:TemporalOperator[@name='During']";
        ETSAssert.assertXPath((String)xPathXml, (Node)this.wfsMetadata, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.3., S.24, Requirement 10; OGC 09-026R2 Temporal Filter CC, A.10")
    public void additionalTemporalOperatorIsEnabled() throws XPathFactoryConfigurationException, XPathExpressionException {
        List<String> supportedTemporalOperators = this.parseExpectedTemporalOperators(this.wfsMetadata, EXPECTED_TEMPORAL_OPERATORS);
        Assert.assertTrue((supportedTemporalOperators.size() > 0 ? 1 : 0) != 0, (String)("TemporalOperators are not valid. At least one of the temporal operators " + EXPECTED_TEMPORAL_OPERATORS + " must be supported"));
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.3., S.24, Requirement 10; OGC 09-026R2 Temporal Filter CC, A.10", dataProvider="protocol-featureType-duringOperator")
    public void withDuringFilter(ProtocolBinding binding, AbstractTemporalFilterTest.FeatureTypeToPropertyAndValue featureTypeToPropertyAndValue, String duringOperator) {
        this.executeWithTemporalFilterTest(binding, featureTypeToPropertyAndValue, duringOperator);
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.3., S.24, Requirement 10; OGC 09-026R2 Temporal Filter CC, A.10", dataProvider="protocol-featureType-temporalOperator")
    public void withTemporalOperatorFilter(ProtocolBinding binding, AbstractTemporalFilterTest.FeatureTypeToPropertyAndValue featureTypeToPropertyAndValue, String temporalOperatorName) {
        this.executeWithTemporalFilterTest(binding, featureTypeToPropertyAndValue, temporalOperatorName);
    }

    private void executeWithTemporalFilterTest(ProtocolBinding binding, AbstractTemporalFilterTest.FeatureTypeToPropertyAndValue featureTypeToPropertyAndValue, String temporalOperatorName) {
        this.checkIfDataProviderFoundTestableData(binding, featureTypeToPropertyAndValue, temporalOperatorName);
        Element valueRef = WFSMessage.createValueReference((XSElementDeclaration)featureTypeToPropertyAndValue.getProperty());
        WFSMessage.appendSimpleQuery((Document)this.reqEntity, (QName[])new QName[]{featureTypeToPropertyAndValue.getFeatureType()});
        this.addTemporalOperatorPredicate(this.reqEntity, temporalOperatorName, valueRef, featureTypeToPropertyAndValue.getValueRange());
        Response rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get((String)"UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp);
        ETSAssert.assertSchemaValid((Schema)this.wfsSchema, (Document)this.rspEntity);
    }
}

