/*
 * Decompiled with CFR 0.152.
 */
package com.bric.geom;

import java.awt.geom.PathIterator;

public class SimplifiedPathIterator
implements PathIterator {
    private static final double TOL = 1.0E-4;
    PathIterator i;
    double lastX;
    double lastY;
    private static double[] doubleArray = new double[6];
    private double[] d;

    public SimplifiedPathIterator(PathIterator i) {
        this.i = i;
    }

    public static boolean collinear(double x1, double y1, double x2, double y2, double x3, double y3) {
        double determinant = x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2);
        return Math.abs(determinant) < 1.0E-8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int simplify(int type, float lastX, float lastY, float[] data) {
        double[] dArray = doubleArray;
        synchronized (doubleArray) {
            for (int a = 0; a < data.length; ++a) {
                SimplifiedPathIterator.doubleArray[a] = data[a];
            }
            int returnValue = SimplifiedPathIterator.simplify(type, (double)lastX, (double)lastY, doubleArray);
            for (int a = 0; a < data.length; ++a) {
                data[a] = (float)doubleArray[a];
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return returnValue;
        }
    }

    public static int simplify(int type, double lastX, double lastY, double[] data) {
        if (type == 3) {
            if (SimplifiedPathIterator.collinear(lastX, lastY, data[4], data[5], data[0], data[1]) && SimplifiedPathIterator.collinear(lastX, lastY, data[4], data[5], data[2], data[3])) {
                data[0] = data[4];
                data[1] = data[5];
                return 1;
            }
            double ax = -lastX + 3.0 * data[0] - 3.0 * data[2] + data[4];
            double ay = -lastY + 3.0 * data[1] - 3.0 * data[3] + data[5];
            if (Math.abs(ax) < 1.0E-6 && Math.abs(ay) < 1.0E-6) {
                double bx = 3.0 * lastX - 6.0 * data[0] + 3.0 * data[2];
                double cx = -3.0 * lastX + 3.0 * data[0];
                double by = 3.0 * lastY - 6.0 * data[1] + 3.0 * data[3];
                double cy = -3.0 * lastY + 3.0 * data[1];
                data[1] = (cy + 2.0 * lastY) / 2.0;
                data[3] = by - lastY + 2.0 * data[1];
                data[0] = (cx + 2.0 * lastX) / 2.0;
                data[2] = bx - lastX + 2.0 * data[0];
                return SimplifiedPathIterator.simplify(2, lastX, lastY, data);
            }
        } else if (type == 2) {
            if (SimplifiedPathIterator.collinear(lastX, lastY, data[2], data[3], data[0], data[1])) {
                data[0] = data[2];
                data[1] = data[3];
                return 1;
            }
            double ax = lastX - 2.0 * data[0] + data[2];
            double ay = lastY - 2.0 * data[1] + data[3];
            if (Math.abs(ax) < 1.0E-6 && Math.abs(ay) < 1.0E-6) {
                double bx = -2.0 * lastX + 2.0 * data[0];
                double by = -2.0 * lastY + 2.0 * data[1];
                data[0] = (bx + 2.0 * lastX) / 2.0;
                data[1] = (by + 2.0 * lastY) / 2.0;
                return 1;
            }
        }
        return type;
    }

    @Override
    public int currentSegment(double[] f) {
        int type = this.i.currentSegment(f);
        if ((type = SimplifiedPathIterator.simplify(type, this.lastX, this.lastY, f)) == 1 || type == 0) {
            this.lastX = f[0];
            this.lastY = f[1];
        } else if (type == 2) {
            this.lastX = f[2];
            this.lastY = f[3];
        } else if (type == 3) {
            this.lastX = f[4];
            this.lastY = f[5];
        }
        return type;
    }

    @Override
    public int currentSegment(float[] f) {
        if (this.d == null) {
            this.d = new double[6];
        }
        int k = this.currentSegment(this.d);
        f[0] = (float)this.d[0];
        f[1] = (float)this.d[1];
        f[2] = (float)this.d[2];
        f[3] = (float)this.d[3];
        f[4] = (float)this.d[4];
        f[5] = (float)this.d[5];
        return k;
    }

    @Override
    public int getWindingRule() {
        return this.i.getWindingRule();
    }

    @Override
    public boolean isDone() {
        return this.i.isDone();
    }

    @Override
    public void next() {
        this.i.next();
    }
}

