/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.feature.jts.Factory;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.GeodeticCalculator;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.geotoolkit.display.shape.ShapeUtilities;
import org.geotoolkit.geometry.jts.JTSEnvelope2D;
import org.geotoolkit.geometry.jts.SRIDGenerator;
import org.geotoolkit.geometry.jts.awt.JTSGeometryJ2D;
import org.geotoolkit.resources.Errors;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class JTS {
    private static final GeneralDirectPosition[] POSITIONS = new GeneralDirectPosition[4];
    private static final Map<CoordinateReferenceSystem, GeodeticCalculator> CALCULATORS;

    private JTS() {
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format((short)145, name));
        }
    }

    public static void ensureClosed(Coordinate[] array) {
        if (!array[0].equals2D(array[array.length - 1])) {
            array[array.length - 1].setCoordinate(array[0]);
        }
    }

    public static Envelope transform(Envelope envelope, MathTransform transform) throws TransformException {
        return JTS.transform(envelope, null, transform, 5);
    }

    public static Envelope transform(Envelope sourceEnvelope, Envelope targetEnvelope, MathTransform transform, int npoints) throws TransformException {
        int t;
        JTS.ensureNonNull("sourceEnvelope", sourceEnvelope);
        JTS.ensureNonNull("transform", transform);
        if (transform.getSourceDimensions() != 2 || transform.getTargetDimensions() != 2) {
            throw new MismatchedDimensionException(Errors.format((short)73, Classes.getShortClassName((Object)transform)));
        }
        double[] coordinates = new double[4 * ++npoints * 2];
        double xmin = sourceEnvelope.getMinX();
        double xmax = sourceEnvelope.getMaxX();
        double ymin = sourceEnvelope.getMinY();
        double ymax = sourceEnvelope.getMaxY();
        double scaleX = (xmax - xmin) / (double)npoints;
        double scaleY = (ymax - ymin) / (double)npoints;
        int offset = 0;
        for (t = 0; t < npoints; ++t) {
            double dx = scaleX * (double)t;
            double dy = scaleY * (double)t;
            coordinates[offset++] = xmin;
            coordinates[offset++] = ymin + dy;
            coordinates[offset++] = xmin + dx;
            coordinates[offset++] = ymax;
            coordinates[offset++] = xmax;
            coordinates[offset++] = ymax - dy;
            coordinates[offset++] = xmax - dx;
            coordinates[offset++] = ymin;
        }
        assert (offset == coordinates.length);
        JTS.xform(transform, coordinates, coordinates);
        if (targetEnvelope == null) {
            targetEnvelope = new Envelope();
        }
        t = 0;
        while (t < offset) {
            targetEnvelope.expandToInclude(coordinates[t++], coordinates[t++]);
        }
        return targetEnvelope;
    }

    public static Coordinate transform(Coordinate source, Coordinate dest, MathTransform transform) throws TransformException {
        JTS.ensureNonNull("source", source);
        JTS.ensureNonNull("transform", transform);
        if (dest == null) {
            dest = new Coordinate();
        }
        double[] array = new double[transform.getSourceDimensions()];
        JTS.copy(source, array);
        transform.transform(array, 0, array, 0, 1);
        switch (transform.getTargetDimensions()) {
            case 3: {
                dest.z = array[2];
            }
            case 2: {
                dest.y = array[1];
            }
            case 1: {
                dest.x = array[0];
            }
        }
        return dest;
    }

    public static Envelope toGeographic(Envelope envelope, CoordinateReferenceSystem crs) throws TransformException {
        MathTransform transform;
        if (Utilities.equalsIgnoreMetadata((Object)crs, (Object)CommonCRS.WGS84.normalizedGeographic())) {
            return envelope;
        }
        try {
            transform = CRS.findOperation((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)CommonCRS.WGS84.normalizedGeographic(), null).getMathTransform();
        }
        catch (FactoryException exception) {
            throw new TransformException(Errors.format((short)23, (Object)exception));
        }
        return JTS.transform(envelope, transform);
    }

    public static void xform(MathTransform transform, double[] src, double[] dest) throws TransformException {
        JTS.ensureNonNull("transform", transform);
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        if (targetDim != sourceDim) {
            throw new MismatchedDimensionException();
        }
        TransformException firstError = null;
        boolean startPointTransformed = false;
        for (int i = 0; i < src.length; i += sourceDim) {
            try {
                transform.transform(src, i, dest, i, 1);
                if (startPointTransformed) continue;
                startPointTransformed = true;
                for (int j = 0; j < i; ++j) {
                    System.arraycopy(dest, j, dest, i, targetDim);
                }
                continue;
            }
            catch (TransformException e) {
                if (firstError == null) {
                    firstError = e;
                }
                if (!startPointTransformed) continue;
                System.arraycopy(dest, i - targetDim, dest, i, targetDim);
            }
        }
        if (!startPointTransformed && firstError != null) {
            throw firstError;
        }
    }

    public static synchronized double orthodromicDistance(Coordinate p1, Coordinate p2, CoordinateReferenceSystem crs) throws TransformException {
        JTS.ensureNonNull("p1", p1);
        JTS.ensureNonNull("p2", p2);
        JTS.ensureNonNull("crs", crs);
        GeodeticCalculator gc = CALCULATORS.get(crs);
        if (gc == null) {
            gc = GeodeticCalculator.create((CoordinateReferenceSystem)crs);
            CALCULATORS.put(crs, gc);
        }
        assert (crs.equals(gc.getPositionCRS())) : crs;
        GeneralDirectPosition pos = POSITIONS[Math.min(POSITIONS.length - 1, crs.getCoordinateSystem().getDimension())];
        pos.setCoordinateReferenceSystem(crs);
        JTS.copy(p1, pos.coordinates);
        gc.setStartPoint((Position)pos);
        JTS.copy(p2, pos.coordinates);
        gc.setEndPoint((Position)pos);
        return gc.getGeodesicDistance();
    }

    public static void copy(Coordinate point, double[] coordinates) {
        JTS.ensureNonNull("point", point);
        JTS.ensureNonNull("coordinates", coordinates);
        switch (coordinates.length) {
            default: {
                Arrays.fill(coordinates, 3, coordinates.length, Double.NaN);
            }
            case 3: {
                coordinates[2] = point.z;
            }
            case 2: {
                coordinates[1] = point.y;
            }
            case 1: {
                coordinates[0] = point.x;
            }
            case 0: 
        }
    }

    public static Geometry shapeToGeometry(Shape shape, GeometryFactory factory) {
        if (shape instanceof JTSGeometryJ2D) {
            JTSGeometryJ2D jtsgeom = (JTSGeometryJ2D)shape;
            Object geometry = jtsgeom.getGeometry();
            MathTransform transform = jtsgeom.getTransform();
            if (!transform.isIdentity()) {
                try {
                    geometry = org.apache.sis.internal.feature.jts.JTS.transform(geometry, (MathTransform)transform);
                }
                catch (MismatchedDimensionException | TransformException ex) {
                    throw new BackingStoreException(ex.getMessage(), ex);
                }
            }
            return geometry;
        }
        JTS.ensureNonNull("shape", shape);
        JTS.ensureNonNull("factory", factory);
        PathIterator iterator = shape.getPathIterator(null, ShapeUtilities.getFlatness(shape));
        double[] buffer = new double[6];
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        ArrayList<LineString> lines = new ArrayList<LineString>();
        while (!iterator.isDone()) {
            switch (iterator.currentSegment(buffer)) {
                case 4: {
                    if (coords.isEmpty()) break;
                    coords.add((Coordinate)coords.get(0));
                    while (coords.size() < 4) {
                        coords.add((Coordinate)coords.get(0));
                    }
                    lines.add(factory.createLinearRing(coords.toArray(new Coordinate[coords.size()])));
                    coords.clear();
                    break;
                }
                case 0: {
                    if (!coords.isEmpty()) {
                        lines.add(factory.createLineString(coords.toArray(new Coordinate[coords.size()])));
                        coords.clear();
                    }
                }
                case 1: {
                    coords.add(new Coordinate(buffer[0], buffer[1]));
                    break;
                }
                default: {
                    throw new IllegalPathStateException();
                }
            }
            iterator.next();
        }
        if (!coords.isEmpty()) {
            lines.add(factory.createLineString(coords.toArray(new Coordinate[coords.size()])));
        }
        switch (lines.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (LineString)lines.get(0);
            }
        }
        return factory.createMultiLineString(GeometryFactory.toLineStringArray(lines));
    }

    public static Envelope2D getEnvelope2D(Envelope envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        JTS.ensureNonNull("envelope", envelope);
        JTS.ensureNonNull("crs", crs);
        SingleCRS crs2D = CRS.getHorizontalComponent((CoordinateReferenceSystem)crs);
        if (crs2D == null) {
            throw new MismatchedDimensionException(Errors.format((short)21, crs));
        }
        return new Envelope2D((CoordinateReferenceSystem)crs2D, envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight());
    }

    public static Polygon toGeometry(Rectangle envelope) {
        GeometryFactory gf = JTS.getFactory();
        return gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMinY())}), null);
    }

    public static Polygon toGeometry(Envelope envelope) {
        GeometryFactory gf = JTS.getFactory();
        return gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMinY())}), null);
    }

    @Deprecated
    public static Polygon toGeometry(org.opengis.geometry.Envelope env) {
        GeometryFactory gf = JTS.getFactory();
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(env.getMinimum(0), env.getMinimum(1)), new Coordinate(env.getMinimum(0), env.getMaximum(1)), new Coordinate(env.getMaximum(0), env.getMaximum(1)), new Coordinate(env.getMaximum(0), env.getMinimum(1)), new Coordinate(env.getMinimum(0), env.getMinimum(1))};
        LinearRing ring = gf.createLinearRing(coordinates);
        return gf.createPolygon(ring, new LinearRing[0]);
    }

    public static JTSEnvelope2D toEnvelope(Geometry geom) {
        if (geom == null) {
            return null;
        }
        Object srsName = null;
        Object userData = geom.getUserData();
        if (userData != null && userData instanceof String) {
            srsName = (String)userData;
        } else if (geom.getSRID() > 0) {
            srsName = "EPSG:" + geom.getSRID();
        }
        CoordinateReferenceSystem crs = null;
        if (userData != null && userData instanceof CoordinateReferenceSystem) {
            crs = (CoordinateReferenceSystem)userData;
        } else if (srsName != null) {
            try {
                crs = CRS.forCode((String)srsName);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
            }
            catch (FactoryException factoryException) {
                // empty catch block
            }
        }
        return new JTSEnvelope2D(geom.getEnvelopeInternal(), crs);
    }

    public static <T extends Geometry> T emptyGeometry(Class<T> geomClass, CoordinateReferenceSystem crs, GeometryFactory factory) {
        Geometry geometry;
        ArgumentChecks.ensureNonNull((String)"geometry class", geomClass);
        if (factory == null) {
            factory = JTS.getFactory();
        }
        if (Point.class.equals(geomClass)) {
            geometry = factory.createPoint((Coordinate)null);
        } else if (LineString.class.equals(geomClass)) {
            geometry = factory.createLineString((CoordinateSequence)null);
        } else if (Polygon.class.equals(geomClass)) {
            geometry = factory.createPolygon((CoordinateSequence)null);
        } else if (MultiPoint.class.equals(geomClass)) {
            geometry = factory.createMultiPoint((CoordinateSequence)null);
        } else if (MultiLineString.class.equals(geomClass)) {
            geometry = factory.createMultiLineString(null);
        } else if (MultiPolygon.class.equals(geomClass)) {
            geometry = factory.createMultiPolygon(null);
        } else if (GeometryCollection.class.equals(geomClass)) {
            geometry = factory.buildGeometry(null);
        } else {
            throw new IllegalArgumentException("Unknown geometry class " + geomClass.getName());
        }
        if (crs != null) {
            JTS.setCRS(geometry, crs);
        }
        return (T)geometry;
    }

    public static void checkCoordinatesRange(Geometry geom, CoordinateReferenceSystem crs) throws ProjectionException {
        boolean yUnbounded;
        CoordinateSystemAxis x = crs.getCoordinateSystem().getAxis(0);
        CoordinateSystemAxis y = crs.getCoordinateSystem().getAxis(1);
        boolean xUnbounded = Double.isInfinite(x.getMinimumValue()) && Double.isInfinite(x.getMaximumValue());
        boolean bl = yUnbounded = Double.isInfinite(y.getMinimumValue()) && Double.isInfinite(y.getMaximumValue());
        if (xUnbounded && yUnbounded) {
            return;
        }
        Coordinate[] c = geom.getCoordinates();
        for (int i = 0; i < c.length; ++i) {
            if (!xUnbounded && (c[i].x < x.getMinimumValue() || c[i].x > x.getMaximumValue())) {
                throw new ProjectionException(c[i].x + " outside of (" + x.getMinimumValue() + "," + x.getMaximumValue() + ")");
            }
            if (yUnbounded || !(c[i].y < y.getMinimumValue()) && !(c[i].y > y.getMaximumValue())) continue;
            throw new ProjectionException(c[i].y + " outside of (" + y.getMinimumValue() + "," + y.getMaximumValue() + ")");
        }
    }

    public static void setCRS(Geometry geom, CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureNonNull((String)"geometry", (Object)geom);
        if (crs == null) {
            return;
        }
        Object userData = geom.getUserData();
        if (userData instanceof CoordinateReferenceSystem) {
            userData = crs;
        } else if (userData instanceof Map) {
            Map values = (Map)userData;
            values.put("CRS", crs);
            userData = values;
        }
        if (userData == null) {
            userData = crs;
        }
        geom.setUserData(userData);
        try {
            int srid = SRIDGenerator.toSRID(crs, SRIDGenerator.Version.V1);
            geom.setSRID(srid);
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger("org.geotoolkit.geometry").log(Level.FINE, "Cannot update SRID of geometry. It will be reset.", e);
            geom.setSRID(0);
        }
    }

    public static CoordinateReferenceSystem findCoordinateReferenceSystem(Geometry geom) throws NoSuchAuthorityCodeException, FactoryException {
        int srid;
        Map values;
        Object candidate;
        if (geom == null) {
            return null;
        }
        CoordinateReferenceSystem crs = null;
        Object userData = geom.getUserData();
        if (userData instanceof CoordinateReferenceSystem) {
            crs = (CoordinateReferenceSystem)userData;
        } else if (userData instanceof Map && (candidate = (values = (Map)userData).get("CRS")) instanceof CoordinateReferenceSystem) {
            crs = (CoordinateReferenceSystem)candidate;
        }
        if (crs == null && (srid = geom.getSRID()) != 0 && srid != -1) {
            String srs = SRIDGenerator.toSRS(srid, SRIDGenerator.Version.V1);
            crs = CRS.forCode((String)srs);
        }
        return crs;
    }

    public static void zMinMax(CoordinateSequence cs, double[] target) {
        if (cs.getDimension() < 3) {
            return;
        }
        boolean validZFound = false;
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        int size = cs.size();
        for (int t = size - 1; t >= 0; --t) {
            double z = cs.getOrdinate(t, 2);
            if (Double.isNaN(z)) continue;
            if (validZFound) {
                if (z < zmin) {
                    zmin = z;
                }
                if (!(z > zmax)) continue;
                zmax = z;
                continue;
            }
            validZFound = true;
            zmin = z;
            zmax = z;
        }
        if (!Double.isNaN(zmin)) {
            target[0] = zmin;
        }
        if (!Double.isNaN(zmax)) {
            target[1] = zmax;
        }
    }

    public static LinearRing reverseRing(LinearRing lr) {
        GeometryFactory gf = lr.getFactory();
        CoordinateSequence cs = lr.getCoordinateSequence().copy();
        CoordinateSequences.reverse(cs);
        LinearRing reversed = gf.createLinearRing(cs);
        reversed.setSRID(reversed.getSRID());
        reversed.setUserData(lr.getUserData());
        return reversed;
    }

    public static <T extends Geometry> T ensureWinding(T g, boolean clockwise) {
        Predicate<CoordinateSequence> evaluator = Orientation::isCCW;
        if (clockwise) {
            evaluator = evaluator.negate();
        }
        if (g instanceof MultiPolygon || g instanceof Polygon) {
            GeometryFactory gf = g.getFactory();
            boolean isMultiPolygon = false;
            int nbPolygon = 1;
            if (g instanceof MultiPolygon) {
                nbPolygon = g.getNumGeometries();
                isMultiPolygon = true;
            }
            Polygon[] ps = new Polygon[nbPolygon];
            for (int i = 0; i < nbPolygon; ++i) {
                Polygon p = isMultiPolygon ? (Polygon)g.getGeometryN(i) : (Polygon)g;
                LinearRing[] holes = new LinearRing[p.getNumInteriorRing()];
                LinearRing outer = p.getExteriorRing();
                if (!evaluator.test(outer.getCoordinateSequence())) {
                    outer = JTS.reverseRing(p.getExteriorRing());
                }
                int tt = p.getNumInteriorRing();
                for (int t = 0; t < tt; ++t) {
                    holes[t] = p.getInteriorRingN(t);
                    if (!evaluator.test(holes[t].getCoordinateSequence())) continue;
                    holes[t] = JTS.reverseRing(holes[t]);
                }
                ps[i] = gf.createPolygon(outer, holes);
            }
            Geometry reversed = isMultiPolygon ? gf.createMultiPolygon(ps) : ps[0];
            reversed.setSRID(g.getSRID());
            reversed.setUserData(g.getUserData());
            return (T)reversed;
        }
        if (g instanceof LinearRing) {
            LinearRing lr = (LinearRing)g;
            if (!evaluator.test(lr.getCoordinateSequence())) {
                lr = JTS.reverseRing(lr);
            }
            return (T)lr;
        }
        return g;
    }

    public static CoordinateReferenceSystem getCommonCRS(Geometry geom1, Geometry geom2) throws FactoryException, TransformException {
        CoordinateReferenceSystem resultCRS = null;
        CoordinateReferenceSystem crs1 = JTS.findCoordinateReferenceSystem(geom1);
        CoordinateReferenceSystem crs2 = JTS.findCoordinateReferenceSystem(geom2);
        if (crs1 != null) {
            resultCRS = crs1;
        } else if (crs2 != null) {
            resultCRS = crs2;
        }
        return resultCRS;
    }

    public static Geometry convertToCRS(Geometry geom, CoordinateReferenceSystem crsTarget) throws MismatchedDimensionException, TransformException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"geometry", (Object)geom);
        ArgumentChecks.ensureNonNull((String)"crsTarget", (Object)crsTarget);
        CoordinateReferenceSystem crsGeom = JTS.findCoordinateReferenceSystem(geom);
        if (crsGeom == null) {
            return geom;
        }
        MathTransform mt = CRS.findOperation((CoordinateReferenceSystem)crsGeom, (CoordinateReferenceSystem)crsTarget, null).getMathTransform();
        Geometry result = org.apache.sis.internal.feature.jts.JTS.transform((Geometry)geom, (MathTransform)mt);
        JTS.setCRS(result, crsTarget);
        return result;
    }

    public static boolean isConversionNeeded(Geometry geom1, Geometry geom2) throws FactoryException {
        CoordinateReferenceSystem crs1 = JTS.findCoordinateReferenceSystem(geom1);
        CoordinateReferenceSystem crs2 = JTS.findCoordinateReferenceSystem(geom2);
        return crs1 != null && crs2 != null && !crs1.equals(crs2);
    }

    public static Geometry fromAwt(GeometryFactory factory, Shape shp, double flatness) {
        return JTS.fromAwt(factory, shp.getPathIterator(null, flatness));
    }

    public static Geometry fromAwt(GeometryFactory factory, PathIterator ite) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        boolean allPolygons = true;
        boolean allPoints = true;
        boolean allLines = true;
        while (!ite.isDone()) {
            Geometry geom = JTS.nextGeometry(factory, ite);
            if (geom == null) continue;
            geoms.add(geom);
            allPolygons &= geom instanceof Polygon;
            allPoints &= geom instanceof Point;
            allLines &= geom instanceof LineString;
        }
        int count = geoms.size();
        if (count == 0) {
            return factory.createEmpty(2);
        }
        if (count == 1) {
            return (Geometry)geoms.get(0);
        }
        if (allPoints) {
            return factory.createMultiPoint(GeometryFactory.toPointArray(geoms));
        }
        if (allPolygons) {
            Geometry result = (Geometry)geoms.get(0);
            for (int i = 1; i < count; ++i) {
                result = result.symDifference((Geometry)geoms.get(i));
            }
            return result;
        }
        if (allLines) {
            return factory.createMultiLineString(GeometryFactory.toLineStringArray(geoms));
        }
        return factory.createGeometryCollection(GeometryFactory.toGeometryArray(geoms));
    }

    private static Geometry nextGeometry(GeometryFactory factory, PathIterator ite) {
        double[] vertex = new double[6];
        ArrayList<Coordinate> coords = null;
        boolean isRing = false;
        block10: while (!ite.isDone()) {
            switch (ite.currentSegment(vertex)) {
                case 0: {
                    if (coords != null) break block10;
                    coords = new ArrayList<Coordinate>();
                    coords.add(new Coordinate(vertex[0], vertex[1]));
                    ite.next();
                    continue block10;
                }
                case 1: {
                    if (coords == null) {
                        throw new IllegalArgumentException("Invalid path iterator, LINETO without previous MOVETO.");
                    }
                    coords.add(new Coordinate(vertex[0], vertex[1]));
                    ite.next();
                    continue block10;
                }
                case 4: {
                    if (coords == null) {
                        throw new IllegalArgumentException("Invalid path iterator, CLOSE without previous MOVETO.");
                    }
                    isRing = true;
                    if (!coords.isEmpty() && !((Coordinate)coords.get(0)).equals2D((Coordinate)coords.get(coords.size() - 1))) {
                        coords.add(((Coordinate)coords.get(0)).copy());
                    }
                    ite.next();
                    break block10;
                }
                default: {
                    throw new IllegalArgumentException("Invalid path iterator, must contain only flat segments.");
                }
            }
        }
        if (coords == null) {
            return null;
        }
        int size = coords.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return factory.createPoint((Coordinate)coords.get(0));
            }
            case 2: {
                return factory.createLineString(new Coordinate[]{(Coordinate)coords.get(0), (Coordinate)coords.get(1)});
            }
        }
        Coordinate[] array = coords.toArray(new Coordinate[size]);
        if (isRing) {
            return factory.createPolygon(array);
        }
        return factory.createLineString(array);
    }

    public static GeometryFactory getFactory() {
        return Factory.INSTANCE.factory(false);
    }

    static {
        for (int i = 0; i < POSITIONS.length; ++i) {
            JTS.POSITIONS[i] = new GeneralDirectPosition(i);
        }
        CALCULATORS = new HashMap<CoordinateReferenceSystem, GeodeticCalculator>();
    }
}

