/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSPrimitiveBoundary;
import org.geotoolkit.internal.jaxb.RingAdapter;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JTSSurfaceBoundary
extends JTSPrimitiveBoundary
implements SurfaceBoundary {
    private static final long serialVersionUID = 8658623156496260842L;
    @XmlElement(namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=RingAdapter.class)
    private Ring exterior;
    @XmlElement(namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=RingAdapter.class)
    private List<Ring> interior;

    public JTSSurfaceBoundary() {
    }

    public JTSSurfaceBoundary(CoordinateReferenceSystem crs, Ring exterior, List<Ring> interior) {
        super(crs);
        this.exterior = exterior;
        this.interior = interior;
    }

    public JTSSurfaceBoundary(CoordinateReferenceSystem crs, Ring exterior, Ring[] interior) {
        super(crs);
        this.exterior = exterior;
        if (interior != null) {
            this.interior = new ArrayList<Ring>(Arrays.asList(interior));
        }
    }

    public Ring getExterior() {
        return this.exterior;
    }

    public List<Ring> getInteriors() {
        return this.interior;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JTSSurfaceBoundary && super.equals(object)) {
            JTSSurfaceBoundary that = (JTSSurfaceBoundary)object;
            return Objects.equals(this.exterior, that.exterior) && Objects.equals(this.interior, that.interior);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 17 * hash + (this.exterior != null ? this.exterior.hashCode() : 0);
        hash = 17 * hash + (this.interior != null ? this.interior.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.interior != null) {
            for (Ring r : this.interior) {
                sb.append("interior:").append(r).append('\n');
            }
        }
        if (this.exterior != null) {
            sb.append("exterior:").append(this.exterior).append('\n');
        }
        return sb.toString();
    }
}

