/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.List;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.storage.StoreResource;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.util.GenericName;

public abstract class GridResourceWrapper
implements GridCoverageResource {
    private volatile GridCoverageResource source;

    protected GridResourceWrapper() {
    }

    protected abstract Object getSynchronizationLock();

    protected abstract GridCoverageResource createSource() throws DataStoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final GridCoverageResource source() throws DataStoreException {
        GridCoverageResource s = this.source;
        if (s == null) {
            Object object = this.getSynchronizationLock();
            synchronized (object) {
                s = this.source;
                if (s == null) {
                    this.source = s = this.createSource();
                }
            }
        }
        return s;
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return this.source().getIdentifier();
    }

    @Override
    public Metadata getMetadata() throws DataStoreException {
        return this.source().getMetadata();
    }

    @Override
    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return this.source().getEnvelope();
    }

    @Override
    public GridGeometry getGridGeometry() throws DataStoreException {
        return this.source().getGridGeometry();
    }

    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        return this.source().getSampleDimensions();
    }

    @Override
    public List<double[]> getResolutions() throws DataStoreException {
        return this.source().getResolutions();
    }

    @Override
    public GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        return this.source().read(domain, ranges);
    }

    @Override
    public RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        return this.source().getLoadingStrategy();
    }

    @Override
    public boolean setLoadingStrategy(RasterLoadingStrategy strategy) throws DataStoreException {
        return this.source().setLoadingStrategy(strategy);
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        GridCoverageResource source;
        try {
            source = this.source();
        }
        catch (DataStoreException e) {
            throw new BackingStoreException(e);
        }
        source.addListener(eventType, listener);
    }

    @Override
    public <T extends StoreEvent> void removeListener(Class<T> eventType, StoreListener<? super T> listener) {
        GridCoverageResource s = this.source;
        if (s != null) {
            s.removeListener(eventType, listener);
        }
    }

    public final void closeDataStore() throws DataStoreException {
        GridCoverageResource s = this.source;
        this.source = null;
        if (s instanceof StoreResource) {
            ((StoreResource)((Object)s)).getOriginator().close();
        }
    }
}

