/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.esri;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.jdk17.JDK17;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.util.resources.Errors;

final class CharactersView
implements CharSequence {
    private static final char SPACE = ' ';
    final ChannelDataInput input;
    private final ByteBuffer buffer;
    private final byte[] array;
    private final boolean direct;

    CharactersView(ChannelDataInput input, ByteBuffer buffer) {
        this.input = input;
        this.buffer = buffer;
        this.direct = buffer.hasArray();
        this.array = this.direct ? buffer.array() : new byte[80];
    }

    @Override
    public int length() {
        return this.buffer.limit();
    }

    @Override
    public char charAt(int index) {
        return (char)Byte.toUnsignedInt(this.buffer.get(index));
    }

    final Map<String, String> readHeader() throws IOException, DataStoreContentException {
        HashMap<String, String> header = new HashMap<String, String>();
        while (true) {
            String key;
            char c;
            if ((c = (key = this.readToken()).charAt(0)) != '#') {
                if (!Character.isJavaIdentifierStart(c)) {
                    this.buffer.position(this.buffer.position() - key.length() - 1);
                    return header;
                }
                Object value = null;
                while (!this.skipLine(true)) {
                    this.buffer.position(this.buffer.position() - 1);
                    String next = this.readToken();
                    if (value == null) {
                        value = next;
                        continue;
                    }
                    value = (String)value + " " + next;
                }
                String old = header.put(key = key.toUpperCase(Locale.US), (String)value);
                if (old != null && !old.equals(value)) {
                    if (value == null) {
                        header.put(key, old);
                    } else {
                        throw new DataStoreContentException(Errors.format((short)24, key));
                    }
                }
            }
            this.skipLine(false);
        }
    }

    private int readByte() throws IOException {
        if (!this.buffer.hasRemaining()) {
            if (this.input == null) {
                throw new EOFException();
            }
            this.input.ensureBufferContains(1);
        }
        return Byte.toUnsignedInt(this.buffer.get());
    }

    private boolean skipLine(boolean stopAtToken) throws IOException {
        int c;
        this.buffer.position(this.buffer.position() - 1);
        boolean eol = false;
        do {
            boolean bl = eol = (c = this.readByte()) == 13 || c == 10;
        } while (!eol && (!stopAtToken || c <= 32));
        return eol;
    }

    final String readToken() throws IOException, DataStoreContentException {
        int c;
        while (this.readByte() <= 32) {
        }
        int start = this.buffer.position() - 1;
        do {
            if (this.buffer.hasRemaining()) continue;
            if (this.input == null) {
                throw new EOFException();
            }
            this.buffer.position(start);
            int current = this.buffer.limit() - start;
            if (current >= this.buffer.capacity()) {
                throw new DataStoreContentException(Resources.format((short)67, this.input.filename));
            }
            this.input.ensureBufferContains(current + 1);
            this.buffer.position(current);
            start = 0;
        } while ((c = Byte.toUnsignedInt(this.buffer.get())) > 32);
        return this.subSequence(start, this.buffer.position() - 1);
    }

    @Override
    public String subSequence(int start, int end) {
        int length = end - start;
        if (this.direct) {
            return new String(this.array, start, length, StandardCharsets.US_ASCII);
        }
        if (length <= this.array.length) {
            JDK17.get(this.buffer, start, this.array, 0, length);
            return new String(this.array, 0, length, StandardCharsets.US_ASCII);
        }
        byte[] data = new byte[length];
        JDK17.get(this.buffer, start, data);
        return new String(data, StandardCharsets.US_ASCII);
    }

    @Override
    public String toString() {
        return this.subSequence(0, this.length());
    }
}

