/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.apache.sis.math.Vector;

public abstract class ByteWriter {
    private ByteWriter() {
    }

    public static ByteWriter create(Vector source, byte[] target) {
        return ByteWriter.create(source.buffer().orElseGet(() -> DoubleBuffer.wrap(source.doubleValues())), ByteBuffer.wrap(target).order(ByteOrder.nativeOrder()));
    }

    public static ByteWriter create(Buffer source, ByteBuffer target) {
        if (source.limit() != source.capacity()) {
            source = source.slice();
        }
        if (source instanceof DoubleBuffer) {
            return new Doubles((DoubleBuffer)source, target);
        }
        if (source instanceof FloatBuffer) {
            return new Floats((FloatBuffer)source, target);
        }
        if (source instanceof LongBuffer) {
            return new Longs((LongBuffer)source, target);
        }
        if (source instanceof IntBuffer) {
            return new Integers((IntBuffer)source, target);
        }
        if (source instanceof ShortBuffer) {
            return new Shorts((ShortBuffer)source, target);
        }
        if (source instanceof ByteBuffer) {
            return new Bytes((ByteBuffer)source, target);
        }
        throw new IllegalArgumentException();
    }

    public abstract int write();

    private static void reset(Buffer source, Buffer target) {
        target.clear();
        source.limit(Math.min(source.capacity(), source.position() + target.capacity()));
    }

    private static final class Doubles
    extends ByteWriter {
        private final DoubleBuffer source;
        private final DoubleBuffer target;

        Doubles(DoubleBuffer source, ByteBuffer target) {
            this.source = source;
            this.target = target.asDoubleBuffer();
        }

        @Override
        public int write() {
            ByteWriter.reset(this.source, this.target);
            this.target.put(this.source);
            return this.target.position() * 8;
        }
    }

    private static final class Floats
    extends ByteWriter {
        private final FloatBuffer source;
        private final FloatBuffer target;

        Floats(FloatBuffer source, ByteBuffer target) {
            this.source = source;
            this.target = target.asFloatBuffer();
        }

        @Override
        public int write() {
            ByteWriter.reset(this.source, this.target);
            this.target.put(this.source);
            return this.target.position() * 4;
        }
    }

    private static final class Longs
    extends ByteWriter {
        private final LongBuffer source;
        private final LongBuffer target;

        Longs(LongBuffer source, ByteBuffer target) {
            this.source = source;
            this.target = target.asLongBuffer();
        }

        @Override
        public int write() {
            ByteWriter.reset(this.source, this.target);
            this.target.put(this.source);
            return this.target.position() * 8;
        }
    }

    private static final class Integers
    extends ByteWriter {
        private final IntBuffer source;
        private final IntBuffer target;

        Integers(IntBuffer source, ByteBuffer target) {
            this.source = source;
            this.target = target.asIntBuffer();
        }

        @Override
        public int write() {
            ByteWriter.reset(this.source, this.target);
            this.target.put(this.source);
            return this.target.position() * 4;
        }
    }

    private static final class Shorts
    extends ByteWriter {
        private final ShortBuffer source;
        private final ShortBuffer target;

        Shorts(ShortBuffer source, ByteBuffer target) {
            this.source = source;
            this.target = target.asShortBuffer();
        }

        @Override
        public int write() {
            ByteWriter.reset(this.source, this.target);
            this.target.put(this.source);
            return this.target.position() * 2;
        }
    }

    private static final class Bytes
    extends ByteWriter {
        private final ByteBuffer source;
        private final ByteBuffer target;

        Bytes(ByteBuffer source, ByteBuffer target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public int write() {
            ByteWriter.reset(this.source, this.target);
            this.target.put(this.source);
            return this.target.position() * 1;
        }
    }
}

