/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.wkt;

import java.text.ParseException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.referencing.DefinitionVerifier;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.referencing.CRS;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public final class StoreFormat
extends WKTFormat {
    private final GeometryLibrary library;
    private final StoreListeners listeners;

    public StoreFormat(Locale locale, TimeZone timezone, GeometryLibrary library, StoreListeners listeners) {
        super(locale, timezone);
        this.library = library;
        this.listeners = listeners;
    }

    public Geometry parseGeometry(String geometry, String crs, String additionalCRS) {
        if (geometry != null) {
            try {
                GeometryWrapper<?> obj = Geometries.implementation(this.library).parseWKT(geometry);
                obj.setCoordinateReferenceSystem(this.parseCRS(crs, additionalCRS));
                return obj;
            }
            catch (Exception e) {
                this.log(e);
            }
        }
        return null;
    }

    public CoordinateReferenceSystem parseCRS(String ... wkt) {
        try {
            CoordinateReferenceSystem[] components = new CoordinateReferenceSystem[wkt.length];
            int n = 0;
            for (String ct : wkt) {
                if (ct == null) continue;
                Object crs = this.parseObject(ct);
                this.validate(crs);
                components[n++] = (CoordinateReferenceSystem)crs;
            }
            if (n != 0) {
                return CRS.compound((CoordinateReferenceSystem[])ArraysExt.resize(components, n));
            }
        }
        catch (ClassCastException | IllegalArgumentException | ParseException | FactoryException e) {
            this.log((Exception)e);
        }
        return null;
    }

    public void validate(Object parsed) {
        Warnings warnings = this.getWarnings();
        if (warnings != null) {
            this.log(new LogRecord(Level.WARNING, warnings.toString()));
        }
        if (parsed instanceof CoordinateReferenceSystem) {
            try {
                LogRecord warning;
                DefinitionVerifier v = DefinitionVerifier.withAuthority((CoordinateReferenceSystem)((CoordinateReferenceSystem)parsed), null, (boolean)false, (Locale)this.getLocale());
                if (v != null && (warning = v.warning(false)) != null) {
                    this.log(warning);
                }
            }
            catch (FactoryException e) {
                this.listeners.warning((Exception)((Object)e));
            }
        }
    }

    private void log(Exception e) {
        this.listeners.warning(Resources.forLocale(this.listeners.getLocale()).getString((short)37, this.listeners.getSourceName()), e);
    }

    private void log(LogRecord record) {
        record.setSourceClassName(this.listeners.getSource().getClass().getName());
        record.setSourceMethodName("getMetadata");
        record.setLoggerName("org.apache.sis.io.wkt");
        this.listeners.warning(record);
    }
}

