/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.filter;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

final class Name
implements ScopedName {
    static final Part STANDARD = new Part("fes");
    static final Part EXTENSION = new Part("extension");
    static final Name LITERAL = new Name(STANDARD, "Literal");
    static final Name VALUE_REFERENCE = new Name(STANDARD, "ValueReference");
    private final LocalName head;
    private final LocalName tail;

    Name(LocalName localName, String string) {
        this.head = localName;
        this.tail = new Part(this, string);
    }

    @Override
    public NameSpace scope() {
        return Space.GLOBAL;
    }

    @Override
    public LocalName head() {
        return this.head;
    }

    @Override
    public GenericName path() {
        return this.head;
    }

    @Override
    public GenericName tail() {
        return this.tail;
    }

    @Override
    public LocalName tip() {
        return this.tail;
    }

    public List<LocalName> getParsedNames() {
        return List.of(this.head, this.tail);
    }

    @Override
    public int depth() {
        return 2;
    }

    @Override
    public GenericName toFullyQualifiedName() {
        return this;
    }

    @Override
    public InternationalString toInternationalString() {
        return new Text(this.toString());
    }

    @Override
    public String toString() {
        return this.head.toString() + ":" + String.valueOf(this.tail);
    }

    @Override
    public int compareTo(GenericName genericName) {
        return Text.compare(this, genericName);
    }

    @Override
    public ScopedName push(GenericName genericName) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.head.hashCode() + 37 * this.tail.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Name) {
            Name name = (Name)object;
            return this.head.equals(name.head) && this.tail.equals(name.tail);
        }
        return false;
    }

    private static final class Part
    implements LocalName {
        private final String name;
        private final GenericName fullyQualified;

        Part(String string) {
            this.name = string;
            this.fullyQualified = this;
        }

        Part(Name name, String string) {
            this.fullyQualified = name;
            this.name = string;
        }

        @Override
        public NameSpace scope() {
            return this.fullyQualified == this ? Space.GLOBAL : new Space(this.fullyQualified.head());
        }

        @Override
        public GenericName toFullyQualifiedName() {
            return this.fullyQualified;
        }

        @Override
        public InternationalString toInternationalString() {
            return new Text(this.name);
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(GenericName genericName) {
            return Text.compare(this, genericName);
        }

        @Override
        public ScopedName push(GenericName genericName) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.name.hashCode() ^ 0xA7967AEF;
        }

        public boolean equals(Object object) {
            return object instanceof Part && this.name.equals(((Part)object).name);
        }
    }

    private static final class Space
    implements NameSpace {
        private static final GenericName NAME = new Part("global");
        static final Space GLOBAL = new Space(NAME);
        private final GenericName name;

        Space(GenericName genericName) {
            this.name = genericName;
        }

        @Override
        public boolean isGlobal() {
            return this.name == NAME;
        }

        @Override
        public GenericName name() {
            return this.name;
        }
    }

    private static final class Text
    implements InternationalString {
        private final String text;

        Text(String string) {
            this.text = string;
        }

        @Override
        public String toString() {
            return this.text;
        }

        @Override
        public String toString(Locale locale) {
            return this.text;
        }

        @Override
        public int length() {
            return this.text.length();
        }

        @Override
        public char charAt(int n) {
            return this.text.charAt(n);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return this.text.subSequence(n, n2);
        }

        @Override
        public int compareTo(InternationalString internationalString) {
            return this.text.compareTo(internationalString.toString());
        }

        static final int compare(GenericName genericName, GenericName genericName2) {
            Iterator<? extends LocalName> iterator = genericName.getParsedNames().iterator();
            Iterator<? extends LocalName> iterator2 = genericName2.getParsedNames().iterator();
            while (iterator.hasNext()) {
                if (!iterator2.hasNext()) {
                    return 1;
                }
                int n = iterator.next().toString().compareTo(iterator2.next().toString());
                if (n == 0) continue;
                return n;
            }
            return iterator2.hasNext() ? -1 : 0;
        }
    }
}

