/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.lineage;

import java.util.Collection;
import java.util.Collections;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.RepresentativeFraction;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.lineage.NominalResolution;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.maintenance.Scope;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@UML(identifier="LI_Source", specification=Specification.ISO_19115)
public interface Source {
    @UML(identifier="description", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public InternationalString getDescription();

    @UML(identifier="sourceSpatialResolution", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Resolution getSourceSpatialResolution() {
        return null;
    }

    @Deprecated
    @UML(identifier="scaleDenominator", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public RepresentativeFraction getScaleDenominator() {
        Resolution resolution = this.getSourceSpatialResolution();
        return resolution != null ? resolution.getEquivalentScale() : null;
    }

    @UML(identifier="sourceReferenceSystem", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public ReferenceSystem getSourceReferenceSystem() {
        return null;
    }

    @UML(identifier="sourceCitation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Citation getSourceCitation() {
        return null;
    }

    @UML(identifier="sourceMetadata", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Citation> getSourceMetadata() {
        return Collections.emptyList();
    }

    @UML(identifier="scope", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Scope getScope();

    @Deprecated
    @UML(identifier="sourceExtent", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115, version=2003)
    default public Collection<? extends Extent> getSourceExtents() {
        return Collections.emptyList();
    }

    @UML(identifier="sourceStep", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends ProcessStep> getSourceSteps() {
        return Collections.emptyList();
    }

    @UML(identifier="processedLevel", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115_2)
    default public Identifier getProcessedLevel() {
        return null;
    }

    @UML(identifier="resolution", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115_2)
    default public NominalResolution getResolution() {
        return null;
    }
}

